/**
* The AVENUE Project
* Language Technologies Institute
* School of Computer Science
* (c) 2007 Carnegie Mellon University
* 
* Corpus Navigator
* Written by Jonathan Clark
*/
package edu.cmu.cs.lti.avenue.navigation.tools;

import info.jonclark.util.StringUtils;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.PrintWriter;

public class ReflexElicitationCorpusExtractor {
	
	public static void main(String[] args) throws Exception {
		if (args.length != 3) {
			System.err.println("Usage: program <e_xml_file> <f_xml_file> <ec_out_file>");
			System.exit(1);
		}

		BufferedReader eIn = new BufferedReader(new FileReader(args[0]));
		BufferedReader fIn = new BufferedReader(new FileReader(args[1]));
		PrintWriter out = new PrintWriter(args[2]);

		String f;
		String fLine;
		String e;
		String eLine;
		while ((fLine = fIn.readLine()) != null) {
			if (fLine.startsWith("<ORIGINAL_TEXT>")) {
				f = StringUtils.substringBetween(fLine, "<ORIGINAL_TEXT>", "</ORIGINAL_TEXT>");

				while ((eLine = eIn.readLine()) != null) {
					if (eLine.startsWith("<ORIGINAL_TEXT>")) {
						e = StringUtils.substringBetween(eLine, "<ORIGINAL_TEXT>",
								"</ORIGINAL_TEXT>");
						
						out.println("newpair");
						out.println("srcsent: " + e);
						out.println("tgtsent: " + f);
						out.println("aligned:");
						out.println("context:");
						out.println("comment:");
						out.println();
						break;
					}
				}

			}
		}

		eIn.close();
		fIn.close();
		out.close();
	}
}




