package edu.cmu.cs.lti.avenue.navigation.tools;

import info.jonclark.util.FileUtils;
import info.jonclark.util.StringUtils;

import java.io.File;
import java.io.PrintWriter;
import java.nio.charset.Charset;

public class PackageForPoornima {
	public static void main(String[] args) throws Exception {
		if (args.length != 3) {
			System.err.println("Usage: program <src_lang> <tgt_lang> <out_file>");
			System.exit(1);
		}

		Charset utf8 = Charset.forName("UTF-8");
		String[] srcLines =
				StringUtils.tokenize(FileUtils.getFileAsString(new File(args[0]), utf8), "\n");
		String[] tgtLines =
				StringUtils.tokenize(FileUtils.getFileAsString(new File(args[1]), utf8), "\n");
		assert srcLines.length == tgtLines.length : "line count mismatch";

		PrintWriter out = new PrintWriter(args[2], utf8.toString());
		for (int i = 0; i < srcLines.length; i++) {
			out.println("newpair");
			out.println("srcsent: " + srcLines[i]);
			out.println("tgtsent: " + tgtLines[i]);
			out.println();
		}
		out.close();
	}
}
