/**
* The AVENUE Project
* Language Technologies Institute
* School of Computer Science
* (c) 2007 Carnegie Mellon University
* 
* Corpus Navigator
* Written by Jonathan Clark
*/
package edu.cmu.cs.lti.avenue.navigation.tools;

import java.io.BufferedReader;
import java.io.InputStreamReader;

/**
 * Produces semi-readable transliterations without vowels
 *
 */
public class OldUrduTransliterator {

	public static void main(String[] args) throws Exception {
		final String ARABIC = "ءٔ◌ٕ◌ابتثجحخدذرزسشصضطظعغفقكلمنهةويى";
		final String ROMAN = "ˈˌ`ʾbtṯǧḥẖdḏrzsšṣḍṭẓʿġfqklmnhẗwyỳ";
		BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
		String line;
		while ((line = in.readLine()) != null) {
			char[] chars = line.toCharArray();
			for (int i = 0; i < chars.length; i++) {
				int n = ARABIC.indexOf(chars[i]);
				if (n != -1) {
					chars[i] = ROMAN.charAt(n);
				}
			}
			System.out.println(chars);
		}
	}
}




