package edu.cmu.cs.lti.avenue.navigation.tools;

import info.jonclark.util.StringUtils;

import java.io.File;
import java.io.PrintWriter;

import edu.cmu.cs.lti.avenue.corpus.Corpus;
import edu.cmu.cs.lti.avenue.corpus.SentencePair;
import edu.cmu.cs.lti.avenue.corpus.Serializer;

public class Normalizer {
	public static void main(String[] args) throws Exception {
		if (args.length != 2) {
			System.err.println("Usage: program <in_file> <out_file>");
			System.exit(1);
		}
		Corpus corpus = Serializer.loadSentencePairs(new File(args[0]), "UTF-8");
		PrintWriter out = new PrintWriter(new File(args[1]), "UTF-8");
		for (final SentencePair pair : corpus.getSentences()) {
			out.println("newpair");
			out.println("srcsent: " + StringUtils.untokenize(pair.getNormalizedSourceTokens()));
			out.println("tgtsent: " + StringUtils.untokenize(pair.getNormalizedTargetTokens()));
			out.println("aligned: " + pair.getNormalizedAlignment());
			out.println();
		}
		out.close();
	}
}
