package edu.cmu.cs.lti.avenue.navigation.tools;

import info.jonclark.util.StringUtils;

import java.io.File;
import java.io.PrintWriter;

import edu.cmu.cs.lti.avenue.corpus.Corpus;
import edu.cmu.cs.lti.avenue.corpus.RawAlignment;
import edu.cmu.cs.lti.avenue.corpus.SentencePair;
import edu.cmu.cs.lti.avenue.corpus.Serializer;

public class MosesConverter {
	public static void main(String[] args) throws Exception {
		if (args.length != 4) {
			System.err.println("Usage: program <in_file> <src_out> <tgt_out> <align_out>");
			System.exit(1);
		}

		Corpus corpus = Serializer.loadSentencePairs(new File(args[0]), "UTF-8");
		PrintWriter srcOut = new PrintWriter(new File(args[1]), "UTF-8");
		PrintWriter tgtOut = new PrintWriter(new File(args[2]), "UTF-8");
		PrintWriter alignOut = new PrintWriter(new File(args[3]), "UTF-8");
		for (final SentencePair pair : corpus.getSentences()) {
			srcOut.println(pair.getDisplaySourceSentence());
			tgtOut.println(pair.getDisplayTargetSentence());
			for (final RawAlignment a : pair.getDisplayAlignment().getRawAlignments()) {
				for (final int srcIndex : a.sourceTerminals) {
					for (final int tgtIndex : a.targetTerminals) {
						alignOut.print((srcIndex - 1) + "-" + (tgtIndex - 1) + " ");
					}
				}
			}
			alignOut.println();
		}
		alignOut.close();
		tgtOut.close();
		srcOut.close();
	}
}
