package edu.cmu.cs.lti.avenue.navigation.tools;

import java.io.File;

import edu.cmu.cs.lti.avenue.corpus.Corpus;
import edu.cmu.cs.lti.avenue.corpus.SentencePair;
import edu.cmu.cs.lti.avenue.corpus.Serializer;

public class Flipper {
	public static void main(String[] args) throws Exception {
		if (args.length != 2) {
			System.err.println("Usage: program <in_file> <out_file>");
			System.exit(1);
		}
		Corpus corpus = Serializer.loadSentencePairs(new File(args[0]), "UTF-8");
		for (final SentencePair pair : corpus.getSentences()) {
			pair.flip();
		}
		Serializer.saveSentencePairs(corpus, new File(args[1]));
	}
}
