package edu.cmu.cs.lti.avenue.navigation.tools;

import info.jonclark.util.LatexUtils;

import java.io.File;
import java.io.PrintWriter;

import edu.cmu.cs.lti.avenue.featurespecification.FeatureSpec;
import edu.cmu.cs.lti.avenue.featurespecification.FeatureStructureManager;
import edu.cmu.cs.lti.avenue.featurespecification.FeatureValueSpec;
import edu.cmu.cs.lti.avenue.featurespecification.Section;

public class FeatureSpecFormatter {
	public static void main(String[] args) throws Exception {

		if (args.length != 3) {
			System.err.println("Usage: program <feature_spec_xml> <latex_out> <csv_out>");
			System.exit(1);
		}

		File xmlFile = new File(args[0]);
		File latexFile = new File(args[1]);
		File csvFile = new File(args[2]);

		FeatureStructureManager fsMan = new FeatureStructureManager(xmlFile);
		PrintWriter latexOut = new PrintWriter(latexFile);
		PrintWriter csvOut = new PrintWriter(csvFile);

		csvOut.println("Section|Name|Value|Always|Sometimes|Never|Morphology|Syntax|Construction|Evidence ID's");

		latexOut.println("\\documentclass[letter,12pt]{report}");
		latexOut.println("\\usepackage[left=1in,top=1in,right=1in,nohead,nofoot, landscape]{geometry}");
		latexOut.println("\\usepackage{makeidx}");
		latexOut.println("\\makeindex");
		latexOut.println("\\usepackage[colorlinks,linkcolor=blue]{hyperref}");
		latexOut.println("\\title{AVENUE: Feature Specification (Abridged)}");
		latexOut.println("\\begin{document}");
		latexOut.println("\\maketitle");
		latexOut.println("\\setcounter{tocdepth}{1}");
		latexOut.println("\\tableofcontents");

		for (final Section section : fsMan.getSections()) {

			if (section.name.equals("Modifiers")) {
				continue;
			}

			latexOut.println("\\chapter{" + section.name + "}");
			for (final String note : section.notes) {
				latexOut.println(clean(note) + "\\\\ \n");
			}
			for (final FeatureSpec featureSpec : section.features) {
				latexOut.println("\\section{" + featureSpec.name + "}");
				latexOut.println(clean(featureSpec.notes));
				for (final FeatureValueSpec valueSpec : featureSpec.values) {

					if (valueSpec.getName().contains("n/a")) {
						continue;
					}

					latexOut.println("\\subsection{" + clean(valueSpec.getName()) + "}");
					latexOut.println("\\index{" + clean(valueSpec.getName()) + "}");
					latexOut.println(clean(valueSpec.getNotes()));
					csvOut.println(section.name + "|" + featureSpec.name + "|"
							+ valueSpec.getName());
				}
			}
		}
		latexOut.println("\\printindex");
		latexOut.println("\\end{document}");
		latexOut.close();
		csvOut.close();
		System.out.println("Done.");
	}

	private static String clean(String str) {
		return LatexUtils.replaceLatexKillers(str);
	}
}
