package edu.cmu.cs.lti.avenue.navigation.tools;

import java.io.File;
import java.io.PrintWriter;

import edu.cmu.cs.lti.avenue.featurespecification.FeatureStructureManager;

// TODO: Remove hack that skips mod-role
public class DumpFeatureSpec {
	public static void main(String[] args) throws Exception {
		
		if (args.length != 3) {
			System.err.println("Usage: program <spec_file_in> <values_out> <roles_out>");
			System.exit(1);
		}
		
		PrintWriter valuesOut = new PrintWriter(args[1]);
		PrintWriter rolesOut = new PrintWriter(args[2]);

		FeatureStructureManager man = new FeatureStructureManager(new File(args[0]));
		for (String feature : man.getFeatureNames()) {
			
			// XXX: HACK
			if(feature.contains("mod-role"))
				continue;
			
			for (String value : man.getAllValuesForFeature(feature)) {
				
				// XXX: HACK
				if(value.contains("n/a"))
					continue;
				
				valuesOut.println("(" + feature + " " + value + ")");
			}
		}
		
		for(String participant : man.getParticipants()) {
			rolesOut.println(participant);
		}
		
		for(String clause : man.getClauseTypes()) {
			rolesOut.println(clause);
		}
		
		rolesOut.close();
		valuesOut.close();
	}
}
