/**
* The AVENUE Project
* Language Technologies Institute
* School of Computer Science
* (c) 2007 Carnegie Mellon University
* 
* Corpus Navigator
* Written by Jonathan Clark
*/
package edu.cmu.cs.lti.avenue.navigation.tools;

import info.jonclark.util.FileUtils;
import info.jonclark.util.StringUtils;

import java.io.File;

/**
 * Puts a copyright notice on files.
 */
public class Copyrighter {

	public static void main(String[] args) throws Exception {
		if (args.length != 1) {
			System.err.println("Usage: program <root_dir>");
			System.exit(1);
		}

		final String strHeader =
				"/**\n" + "* The AVENUE Project\n" + "* Language Technologies Institute\n"
						+ "* School of Computer Science\n"
						+ "* (c) 2007-2008 Carnegie Mellon University\n" + "* \n"
						+ "* Feature Detection & Corpus Navigator\n" + "* By Jonathan Clark\n" + "*/\n";

		File[] files = FileUtils.getFilesWithExt(new File(args[0]), true, ".java");
		for (final File file : files) {
			String strFile = FileUtils.getFileAsString(file);
			if (strFile.contains("package edu.cmu.cs.lti")) {
				String strCode =
						StringUtils.substringAfter(strFile, "package edu.cmu.cs.lti", true);
				strFile = strHeader + strCode;
				FileUtils.saveFileFromString(file, strFile);
			}
		}
	}
}




