/**
 * The AVENUE Project
 * Language Technologies Institute
 * School of Computer Science
 * (c) 2007 Carnegie Mellon University
 * 
 * Corpus Navigator
 * Written by Jonathan Clark
 */
package edu.cmu.cs.lti.avenue.navigation.tools;

import java.io.BufferedReader;
import java.io.FileReader;
import java.text.ParseException;

import edu.cmu.cs.lti.avenue.trees.smart.SmartTree;
import edu.cmu.cs.lti.avenue.trees.smart.SmartTree.LabelMode;

public class CStructureParser {

	public static void main(String[] args) throws Exception {
		BufferedReader in = new BufferedReader(new FileReader("data/english.fixed.parsed"));

		int i = 1;
		int errors = 0;
		String line;
		while ((line = in.readLine()) != null) {

			try {
				// SmartTree<String> tree = parse("( (agent ((feature value)
				// (another-feature 2))))", "n");
				SmartTree tree =
						SmartTree.parse(line, SmartTree.SOURCE_C_STRUCT_LABEL,
								LabelMode.LABEL_ALL_NODES);
				System.out.println(++i + ": " + tree.toString());
			} catch (ParseException e) {
				e.printStackTrace();
				errors++;
			}
		}

		in.close();

		System.out.println("Finished with " + errors + " errors.");

		// for(int i=0; i<tree.nodeList.size(); i++)
		// System.out.println(i + ": " + tree.nodeList.get(i));
	}
}
