package edu.cmu.cs.lti.avenue.navigation.tools;

import info.jonclark.util.FileUtils;
import info.jonclark.util.StringUtils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintWriter;
import java.util.HashMap;

import edu.cmu.cs.lti.avenue.corpus.Corpus;
import edu.cmu.cs.lti.avenue.corpus.SentencePair;
import edu.cmu.cs.lti.avenue.corpus.Serializer;
import edu.cmu.cs.lti.avenue.trees.smart.SmartTree;
import edu.cmu.cs.lti.avenue.trees.smart.SmartTree.LabelDisplay;
import edu.cmu.cs.lti.avenue.trees.smart.SmartTree.LabelMode;

public class CStructureAligner {
	public static void main(String[] args) throws Exception {
		if (args.length != 6) {
			System.err.println("Usage: program <c_structs_file> <elicited_file> <male_names_file> <female_names_file>"
					+ " <elicited_out> <c_structs_out>");
			System.exit(1);
		}

		String encoding = "UTF-8";
		Corpus corpus =
				Serializer.loadSentencePairs(new File(args[1]), encoding);

		String[] maleNames =
				StringUtils.tokenize(FileUtils.getFileAsString(new File(args[2])).toLowerCase(),
						"\n");
		String[] femaleNames =
				StringUtils.tokenize(FileUtils.getFileAsString(new File(args[3])).toLowerCase(),
						"\n");

		HashMap<String, SmartTree> cStructs = new HashMap<String, SmartTree>();
		BufferedReader in = new BufferedReader(new FileReader(args[0]));
		String line;
		while ((line = in.readLine()) != null) {
			SmartTree tree =
					SmartTree.parse(line, SmartTree.SOURCE_C_STRUCT_LABEL,
							LabelMode.LABEL_ALL_NODES);
			String yield = tree.getYield().toLowerCase();
			yield = StringUtils.replaceFast(yield, "''", "\"");
			yield = StringUtils.replaceFast(yield, "``", "\"");
			yield = CFStructureAligner.replaceNames(yield, maleNames, femaleNames);
			cStructs.put(yield, tree);
		}
		in.close();

		PrintWriter sentencesOut = new PrintWriter(args[4], encoding);
		PrintWriter cStructOut = new PrintWriter(args[5], encoding);

		for (final SentencePair elicited : corpus.getSentences()) {
			String strSource = StringUtils.untokenize(elicited.getNormalizedSourceTokens());
			String strTarget = StringUtils.untokenize(elicited.getNormalizedTargetTokens());

			String strSourceNormalized =
					CFStructureAligner.replaceNames(strSource, maleNames, femaleNames);

			SmartTree tree = cStructs.get(strSourceNormalized);
			if (tree == null) {
				System.err.println("WARNING: No tree found for sentence: " + strSource);
			} else {
				String strTree = tree.toString(LabelDisplay.NONE);
				if(strSource.contains("amna")) {
					strTree = StringUtils.replaceFast(strTree, "Sita", "amna");
				}
				if(strSource.contains("danish")) {
					strTree = StringUtils.replaceFast(strTree, "Rama", "danish");
				}
				if(strSource.contains("fiza")) {
					strTree = StringUtils.replaceFast(strTree, "Rama", "fiza");
				}
				if(strSource.contains("ahmed")) {
					strTree = StringUtils.replaceFast(strTree, "Rama", "ahmed");
				}
				cStructOut.println(strTree);

				sentencesOut.println("newpair");
				sentencesOut.println("srcsent: " + strSource);
				sentencesOut.println("tgtsent: " + strTarget);
				sentencesOut.println("aligned: " + elicited.getNormalizedAlignment());
				sentencesOut.println("cstruct: " + strTree);
				sentencesOut.println();
			}
		}

		cStructOut.close();
		sentencesOut.close();

		System.out.println("Please be careful when removing the tray from the microwave oven.");
	}
}
