/**
* The AVENUE Project
* Language Technologies Institute
* School of Computer Science
* (c) 2007 Carnegie Mellon University
* 
* Corpus Navigator
* Written by Jonathan Clark
*/
package edu.cmu.cs.lti.avenue.navigation.tools;

import info.jonclark.util.FileUtils;
import info.jonclark.util.StringUtils;

import java.io.File;

/**
 * Some f-struct files contained the patterns "! " and "!\n " which made the
 * f-structures impossible to parse. This script replaces those occurrances.
 */
public class BangReplacer {
	public static void main(String[] args) throws Exception {
		if (args.length != 1) {
			System.err.println("Usage: program <dir>");
			System.exit(1);
		}

		System.out.println("Getting files for path: " + args[0]);
		File[] files = FileUtils.getFilesWithExt(new File(args[0]), ".txt");
		for (File origFile : files) {
			String newPath = origFile.getAbsolutePath();
			String bakPath = newPath + ".bak";
			
			if(new File(bakPath).exists())
				throw new Error("Backup file already exists: " + bakPath);
			
			if (origFile.renameTo(new File(bakPath))) {
				String wholeFile = FileUtils.getFileAsString(new File(bakPath));
				wholeFile = StringUtils.replaceFast(wholeFile, "!\n ", "");
				wholeFile = StringUtils.replaceFast(wholeFile, "! ", "");
				FileUtils.saveFileFromString(new File(newPath), wholeFile);

				System.out.println(bakPath + " ==> " + newPath);
			}
		}
	}
}




