package edu.cmu.cs.lti.avenue.navigation.search.oracle.cfglm;

import info.jonclark.util.FormatUtils;
import info.jonclark.util.StringUtils;
	public class CfgLanguageModelEntry implements Comparable<CfgLanguageModelEntry> {
		public String rule;
		public int globalFreq;
		public int lhsFreq;
		public double globalProb;
		public double lhsProb;

		public CfgLanguageModelEntry(String rule, int globalFreq) {
			this.rule = rule;
			this.globalFreq = globalFreq;
		}
		
		private CfgLanguageModelEntry() {
		}

		public boolean equals(Object obj) {
			if (obj instanceof CfgLanguageModelEntry) {
				CfgLanguageModelEntry other = (CfgLanguageModelEntry) obj;
				return this.rule.equals(other.rule);
			} else {
				return false;
			}
		}

		public int compareTo(CfgLanguageModelEntry o) {
			return this.rule.compareTo(o.rule);
		}
		
		public static CfgLanguageModelEntry parse(String serialized) {
			CfgLanguageModelEntry entry = new CfgLanguageModelEntry();
			entry.rule = StringUtils.substringBefore(serialized, " =\t").trim();
			
			// hack
			entry.rule = StringUtils.replaceFast(entry.rule, " ]", "]"); 
			
			String remaining = StringUtils.substringAfter(serialized, " =\t").trim();
			String[] values = StringUtils.tokenize(remaining, "\t");
			assert values.length == 4 : "expected 4 values: " + serialized;
			entry.globalFreq = Integer.parseInt(values[0]);
			entry.lhsFreq = Integer.parseInt(values[1]);
			entry.lhsProb = Double.parseDouble(values[2]);
			entry.globalProb = Double.parseDouble(values[3]);
			return entry;
		}

		public String toString() {
			return rule + " =\t" + globalFreq + "\t" + lhsFreq + "\t"
					+ FormatUtils.formatDoubleExp(lhsProb) + "\t"
					+ FormatUtils.formatDoubleExp(globalProb);
		}
	}
