package edu.cmu.cs.lti.avenue.navigation.search.oracle.cfglm;

import info.jonclark.log.LogUtils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Logger;

import edu.cmu.cs.lti.avenue.trees.cfg.CfgRule;

public class CfgLanguageModel {

	private static final Logger log = LogUtils.getLogger();
	private final HashMap<String, CfgLanguageModelEntry> map =
			new HashMap<String, CfgLanguageModelEntry>();
	private double minScore = Double.MAX_VALUE;

	public CfgLanguageModel(File file) throws IOException {
		BufferedReader in = new BufferedReader(new FileReader(file));
		String line;
		while ((line = in.readLine()) != null) {
			
			if(line.startsWith("#"))
				continue;
			
			CfgLanguageModelEntry entry = CfgLanguageModelEntry.parse(line);
			minScore = Math.min(minScore, entry.globalProb);
			map.put(entry.rule, entry);
		}
		in.close();
		log.info("Loaded " + map.size() + " CFG LM entries.");
	}

	public double getScore(CfgRule cfgRule) {
		CfgLanguageModelEntry entry = map.get(cfgRule.toString());

		// TODO: A more reasonable smoothing model
		// current smoothing model is by threshold
		if (entry == null) {
			return minScore;
		} else {
			return entry.globalProb;
		}
	}
}
