package edu.cmu.cs.lti.avenue.navigation.search.generation2.tables;

import info.jonclark.properties.PropertiesException;
import info.jonclark.properties.SmartProperties;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;

public class FeatureLikelihoodTable {

	private final HashMap<String, Integer> weights = new HashMap<String, Integer>();

	public FeatureLikelihoodTable(File file) throws FileNotFoundException, IOException,
			PropertiesException {

		SmartProperties props = new SmartProperties(file);
		for (String key : props.getAllPropertyKeys()) {

			int value = props.getPropertyInt(key);
			weights.put(key, value);
		}
	}

	public int getGrammaticalizationWeight(String featureName, String featureValue) {
		String key = featureName + "." + featureValue + ".G";
		Integer weight = weights.get(key);
		assert weight != null : "No weight found for: " + key;
		return weight;
	}

	public int getUsageWeight(String featureName, String featureValue) {
		String key = featureName + "." + featureValue + ".U";
		Integer weight = weights.get(key);
		assert weight != null : "No weight found for: " + key;
		return weight;
	}
}
