package edu.cmu.cs.lti.avenue.navigation.search.generation2.heuristics;

import java.util.Properties;

import edu.cmu.cs.lti.avenue.morphology.SegmenterException;
import edu.cmu.cs.lti.avenue.navigation.featuredetection.inductive.FeatureExpressionGraphManager;
import edu.cmu.cs.lti.avenue.navigation.search.generation2.Hypothesis;


public class NullHeuristic implements NavigationHeuristic {
	
	public NullHeuristic(Properties props, String namespace) {
		
	}

	public double combineHypothesisScores(double... hyps) {
		double sum = 0.0;
		for (double hyp : hyps)
			sum += hyp;
		return sum;
	}

	public double scoreHypothesis(Hypothesis hyp) {
		return 1.0;
	}

	public void updateCurrentState(FeatureExpressionGraphManager fegMan) throws SegmenterException {
		
	}
}
