package edu.cmu.cs.lti.avenue.navigation.search.generation2.heuristics;

import edu.cmu.cs.lti.avenue.corpus.CorpusException;
import edu.cmu.cs.lti.avenue.morphology.SegmenterException;
import edu.cmu.cs.lti.avenue.navigation.featuredetection.inductive.FeatureExpressionGraphManager;
import edu.cmu.cs.lti.avenue.navigation.search.generation2.Hypothesis;

// TODO: Make this heuristic take in features that only have
// to do with grammatical feature structure or CreatedArcs and CreatedNodes
// so that the heuristics will still apply to the scenario in which
// we're not selecting from a fixed corpus

/**
 * All implementations of this class must provide a constructor parameterized by
 * (Properties props, String namespace)
 */
public interface NavigationHeuristic {
	public double scoreHypothesis(Hypothesis hyp) throws HeuristicException;

	public double combineHypothesisScores(double... hyp);

	/**
	 * Called after each new sentence is elicited to update knowledge-based
	 * components of the heuristics.
	 * 
	 * @param fegMan
	 * @throws SegmenterException
	 * @throws CorpusException 
	 */
	public void updateCurrentState(FeatureExpressionGraphManager fegMan) throws SegmenterException, CorpusException;
}
