package edu.cmu.cs.lti.avenue.navigation.search.generation2.heuristics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

import edu.cmu.cs.lti.avenue.corpus.CorpusException;
import edu.cmu.cs.lti.avenue.morphology.SegmenterException;
import edu.cmu.cs.lti.avenue.navigation.featuredetection.inductive.FeatureExpressionGraphManager;
import edu.cmu.cs.lti.avenue.navigation.search.generation2.Hypothesis;

public class MILESPatternImplicationHeuristic implements NavigationHeuristic {

	private final List<HeuristicPattern> untriggeredExpressions = new ArrayList<HeuristicPattern>();
	private final List<HeuristicPattern> triggeredExpressions = new ArrayList<HeuristicPattern>();

	public MILESPatternImplicationHeuristic() {
		// TODO: Make this configurable...

		String[] lhsFeatures =
				new String[] { "c-assertiveness", "c-causation-directness", "c-causee-control",
						"c-causee-volitionality", "c-copula-type", "c-event-modality",
						"c-my-causer-intentionality", "c-power-relationship", "c-secondaty-type",
						"c-solidarity", "c-source", "c-lexical-aspect" };

		HashSet<String> rhs =
				new HashSet<String>(Arrays.asList(new String[] { "c-v-gram-aspect",
						"c-v-phrase-aspect", "c-v-absolute-tense", "c-event-modality",
						"c-assertiveness", "c-polarity", "c-general-type" }));

		for (String lhsFeature : lhsFeatures) {
			HeuristicPattern pattern = new HeuristicPattern(lhsFeature, rhs);
			untriggeredExpressions.add(pattern);
		}
	}

	public double combineHypothesisScores(double... hyps) {
		double sum = 0.0;
		for (double hyp : hyps)
			sum += hyp;
		return sum;
	}

	public double scoreHypothesis(Hypothesis hyp) throws HeuristicException {

		double score = 0.0;
		for (HeuristicPattern untriggeredPattern : untriggeredExpressions) {
			score += untriggeredPattern.getLhsScores(hyp);
		}
		for (HeuristicPattern triggeredPattern : triggeredExpressions) {
			score += triggeredPattern.getLhsScores(hyp);
			score += triggeredPattern.getRhsScores(hyp);
		}
		return score;
	}

	public void updateCurrentState(FeatureExpressionGraphManager fegMan) throws SegmenterException,
			CorpusException {

		for (int i = 0; i < untriggeredExpressions.size(); i++) {
			HeuristicPattern expression = untriggeredExpressions.get(i);
			if (expression.triggersLhs(fegMan)) {

				// start using this expression when scoring
				triggeredExpressions.add(expression);

				// remove this expression from the untriggered list
				untriggeredExpressions.remove(i);
				i--;
			}
		}
	}

}
