package edu.cmu.cs.lti.avenue.navigation.search.generation2.heuristics;

import info.jonclark.lang.Pair;
import info.jonclark.properties.PropertiesException;
import info.jonclark.properties.SmartProperties;
import info.jonclark.util.StringUtils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;

import edu.cmu.cs.lti.avenue.corpus.CorpusException;
import edu.cmu.cs.lti.avenue.morphology.SegmenterException;
import edu.cmu.cs.lti.avenue.navigation.featuredetection.inductive.FeatureExpressionGraphManager;
import edu.cmu.cs.lti.avenue.navigation.search.generation2.Hypothesis;
import edu.cmu.cs.lti.avenue.navigation.search.generation2.heuristics.expressions.HeuristicExpression;

public class MILESImplicationalUniversalHeuristic implements NavigationHeuristic {

	private final HashMap<Pair<String, String>, Integer> heuristicData =
			new HashMap<Pair<String, String>, Integer>();

	private final List<HeuristicExpression> untriggeredExpressions = new ArrayList<HeuristicExpression>();
	private final List<HeuristicExpression> triggeredExpressions = new ArrayList<HeuristicExpression>();

	public MILESImplicationalUniversalHeuristic(Properties props, String propertiesNamespace)
			throws FileNotFoundException, IOException, PropertiesException, HeuristicException,
			ParseException {

		SmartProperties smartProps = new SmartProperties(props);

		// make sure we have a "." on the end of the namespace
		propertiesNamespace = StringUtils.forceSuffix(propertiesNamespace, ".");

		File heuristicDataFile = smartProps.getPropertyFile(propertiesNamespace + "dataFile");

		BufferedReader in = new BufferedReader(new FileReader(heuristicDataFile));
		boolean inExpressions = false;
		String line;
		while ((line = in.readLine()) != null) {
			line = line.trim();

			if (line.equals("")) {
				continue;
			}

			// see if we're in the right section of the file
			else if (line.startsWith("<")) {
				if (line.equals("<pxgy>")) {
					inExpressions = true;
				} else {
					inExpressions = false;
				}
				continue;
			}

			else if (inExpressions) {
				if (line.startsWith("(*")) {
					String fv = StringUtils.substringBetween(line, "(* (", "))");
					String feature = StringUtils.substringBefore(fv, " ");
					String value = StringUtils.substringAfter(fv, " ");
					String strFreq = StringUtils.substringAfter(line, " = ");
					int freq = parseFrequency(strFreq);

					heuristicData.put(new Pair<String, String>(feature, value), freq);
				} else {
					throw new HeuristicException("Unknown line format: " + line);
				}
			}

			// TODO: Parse each line (* (feature value)) = frequency
			// into some sort of useful data structure

		}
		in.close();
	}

	private static int parseFrequency(String str) throws ParseException {

		if (str.equals("always")) {
			return 3;
		} else if (str.equals("frequently")) {
			return 2;
		} else if (str.equals("occasionally")) {
			return 1;
		} else {
			throw new ParseException("Unknown frequency: " + str, 0);
		}
	}

	public double combineHypothesisScores(double... hyps) {
		double sum = 0.0;
		for (double hyp : hyps)
			sum += hyp;
		return sum;
	}

	public void updateCurrentState(FeatureExpressionGraphManager fegMan) throws SegmenterException,
			CorpusException {

		for (int i = 0; i < untriggeredExpressions.size(); i++) {
			HeuristicExpression expression = untriggeredExpressions.get(i);
			if (expression.isLhsTriggered(fegMan)) {

				// start using this expression when scoring
				triggeredExpressions.add(expression);

				// remove this expression from the untriggered list
				untriggeredExpressions.remove(i);
				i--;
			}
		}
	}

	public double scoreHypothesis(Hypothesis hyp) throws HeuristicException {

		double score = 0.0;

		for (HeuristicExpression expression : triggeredExpressions) {

			double expressionScore =
					expression.scoreUsingRhs(hyp.sent.getSentencePair().getFeatureStructure(),
							hyp.simulationResult.getCreatedNodes());

			score += expressionScore;
		}

		return score;
	}
}
