package edu.cmu.cs.lti.avenue.navigation.search.generation2.heuristics;

import info.jonclark.properties.PropertiesException;
import info.jonclark.properties.SmartProperties;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.ParseException;
import java.util.Properties;

import edu.cmu.cs.lti.avenue.corpus.CorpusException;
import edu.cmu.cs.lti.avenue.morphology.SegmenterException;
import edu.cmu.cs.lti.avenue.navigation.featuredetection.inductive.FeatureExpressionGraphManager;
import edu.cmu.cs.lti.avenue.navigation.search.generation2.Hypothesis;

public class LinearCombinationNavigationHeuristic implements NavigationHeuristic {

	private final NavigationHeuristic[] heuristics;
	private final double[] lambdas;

	public LinearCombinationNavigationHeuristic(Properties props, String namespace)
			throws FileNotFoundException, IOException, PropertiesException, HeuristicException,
			ParseException {

		SmartProperties smartProps = new SmartProperties(props);

		this.heuristics =
				new NavigationHeuristic[] { new ExpressionNavigationHeuristic(props, namespace),
						new MILESPatternImplicationHeuristic(),
						new FeatureInteractionHeuristic(props, namespace) };
		this.lambdas = new double[] { 1.0, 1.0, 1.0 };
	}

	public double combineHypothesisScores(double... hyps) {
		double sum = 0.0;
		for (double hyp : hyps)
			sum += hyp;
		return sum;
	}

	public double scoreHypothesis(Hypothesis hyp) throws HeuristicException {

		double score = 0.0;

		assert heuristics.length == lambdas.length : "array length mismatch";
		for (int i = 0; i < heuristics.length; i++) {
			score += lambdas[i] * heuristics[i].scoreHypothesis(hyp);
		}

		return score;
	}

	public void updateCurrentState(FeatureExpressionGraphManager fegMan) throws SegmenterException,
			CorpusException {

		for (NavigationHeuristic heuristic : this.heuristics) {
			heuristic.updateCurrentState(fegMan);
		}
	}
}
