package edu.cmu.cs.lti.avenue.navigation.search.generation2.heuristics;

import java.util.ArrayList;
import java.util.HashSet;

import edu.cmu.cs.lti.avenue.corpus.CorpusException;
import edu.cmu.cs.lti.avenue.morphology.SegmenterException;
import edu.cmu.cs.lti.avenue.navigation.featuredetection.inductive.FeatureExpressionGraph;
import edu.cmu.cs.lti.avenue.navigation.featuredetection.inductive.FeatureExpressionGraphManager;
import edu.cmu.cs.lti.avenue.navigation.featuredetection.inductive.FeatureValueCluster;
import edu.cmu.cs.lti.avenue.navigation.featuredetection.inductive.simulation.SimulatedNode;
import edu.cmu.cs.lti.avenue.navigation.search.generation2.Hypothesis;
import edu.cmu.cs.lti.avenue.trees.smart.SmartTree;
import edu.cmu.cs.lti.avenue.trees.smart.TreeNode;

public class HeuristicPattern {

	private final String lhs;
	private final HashSet<String> rhs;

	public HeuristicPattern(String lhs, HashSet<String> rhs) {
		this.lhs = lhs;
		this.rhs = rhs;
	}

	public boolean triggersLhs(FeatureExpressionGraphManager fegMan) throws SegmenterException,
			CorpusException {

		ArrayList<FeatureExpressionGraph> fegs = fegMan.getFeatureExpressionGraphs();
		for (FeatureExpressionGraph feg : fegs) {

			boolean isLhsFeature = false;
			for (String featureName : feg.getFeatureInteractions().featureNames) {
				if (lhs.equals(featureName)) {
					isLhsFeature = true;
					break;
				}
			}

			if (isLhsFeature) {
				int nAllValuesJoint = feg.getFeatureInteractions().featureValueInteractions.length;
				for (FeatureValueCluster cluster : feg.getObservedValueClusters()) {
					if (cluster.getFeatureInteractions().size() < nAllValuesJoint) {
						return true;
					}
				}
			}
		}

		return false;
	}

	public double getLhsScores(Hypothesis hyp) {
		SmartTree featureStructure = hyp.sent.getSentencePair().getFeatureStructure();

		boolean good = false;

		// check for a minpair for our lhs
		for (SimulatedNode node : hyp.simulationResult.getCreatedNodes()) {
			if (node.getFeatureName().equals(lhs)) {
				good = true;
				break;
			}
		}

		// check for declarative
		if (good) {
			if (lhs.equals("c-general-type") == false) {
				for (TreeNode terminal : featureStructure.getTerminalNodes()) {
					String featureName = terminal.getValues().get(0);
					if (featureName.equals("c-general-type")) {
						String featureValue = terminal.getValues().get(1);
						if (featureValue.equals("declarative-clause") == false) {
							good = false;
							break;
						}
					}
				}
			}
		}

		// check for positive
		if (good) {
			if (lhs.equals("c-polarity") == false) {
				for (TreeNode terminal : featureStructure.getTerminalNodes()) {
					String featureName = terminal.getValues().get(0);
					if (featureName.equals("c-polarity")) {
						String featureValue = terminal.getValues().get(1);
						if (featureValue.equals("polarity-positive") == false) {
							good = false;
							break;
						}
					}
				}
			}
		}

		// check for present or past tense
		if (good) {
			if (lhs.equals("c-v-absolute-tense") == false) {
				for (TreeNode terminal : featureStructure.getTerminalNodes()) {
					String featureName = terminal.getValues().get(0);
					if (featureName.equals("c-v-absolute-tense")) {
						String featureValue = terminal.getValues().get(1);
						if (featureValue.equals("present") == false && featureValue.equals("past")) {
							good = false;
							break;
						}
					}
				}
			}
		}

		if (good) {
			return 1.0;
		} else {
			return 0.0;
		}
	}

	public double getRhsScores(Hypothesis hyp) {

		boolean good = false;

		// check for a minpair for our lhs
		for (SimulatedNode node : hyp.simulationResult.getCreatedNodes()) {
			if (node.getFeatureName().equals(lhs)) {
				good = true;
				break;
			}
		}

		double result = 0.0;

		if (good) {
			for (SimulatedNode node : hyp.simulationResult.getCreatedNodes()) {
				if (rhs.contains(node.getFeatureName())) {
					result += node.getEvidenceCount();
				}
			}
		}

		return result;
	}
}
