package edu.cmu.cs.lti.avenue.navigation.search.generation2.heuristics;

import info.jonclark.lang.Pair;
import info.jonclark.properties.PropertiesException;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Properties;

import edu.cmu.cs.lti.avenue.morphology.SegmenterException;
import edu.cmu.cs.lti.avenue.navigation.featuredetection.inductive.FeatureExpressionGraphManager;
import edu.cmu.cs.lti.avenue.navigation.featuredetection.inductive.simulation.SimulatedNode;
import edu.cmu.cs.lti.avenue.navigation.search.generation2.Hypothesis;

public class FeatureInteractionHeuristic implements NavigationHeuristic {

	private final HashMap<Pair<String, String>, Integer> heuristicData =
			new HashMap<Pair<String, String>, Integer>();

	public FeatureInteractionHeuristic(Properties props, String propertiesNamespace)
			throws FileNotFoundException, IOException, PropertiesException, HeuristicException,
			ParseException {

		// SmartProperties smartProps = new SmartProperties(props);
		//
		// // make sure we have a "." on the end of the namespace
		// propertiesNamespace = StringUtils.forceSuffix(propertiesNamespace,
		// ".");
		//
		// File heuristicDataFile =
		// smartProps.getPropertyFile(propertiesNamespace + "dataFile");
		//
		// BufferedReader in = new BufferedReader(new
		// FileReader(heuristicDataFile));
		// boolean inExpressions = false;
		// String line;
		// while ((line = in.readLine()) != null) {
		// line = line.trim();
		//
		// if (line.equals("")) {
		// continue;
		// }
		//
		// // see if we're in the right section of the file
		// else if (line.startsWith("<")) {
		// if (line.equals("<pxdy>")) {
		// inExpressions = true;
		// } else {
		// inExpressions = false;
		// }
		// continue;
		// }
		//
		//System.err.println("TODO: Feature Interaction Heuristic: Parse file.")
		// ;
		//
		// // TODO: Parse each line (* (feature value)) = frequency
		// // into some sort of useful data structure
		//
		// }
		// in.close();
	}

	private static int parseFrequency(String str) throws ParseException {

		if (str.equals("always")) {
			return 3;
		} else if (str.equals("frequently")) {
			return 2;
		} else if (str.equals("occasionally")) {
			return 1;
		} else {
			throw new ParseException("Unknown frequency: " + str, 0);
		}
	}

	public double combineHypothesisScores(double... hyps) {
		double sum = 0.0;
		for (double hyp : hyps)
			sum += hyp;
		return sum;
	}

	public double scoreHypothesis(Hypothesis hyp) throws HeuristicException {

		double score = 0.0;

		boolean[] foundLeft = new boolean[1];
		int[] freq = new int[] { 3 };

		// 1) Extract the feature value for each min pair
		for (SimulatedNode simulatedNode : hyp.simulationResult.getCreatedNodes()) {

			String name = simulatedNode.getFeatureName();
			String value = simulatedNode.getFeatureValue();
			int evidenceCount = simulatedNode.getEvidenceCount();

			if (name.equals("c-copula-type")) {
				if (Arrays.asList(
						new String[] { "copula-description", "copula-identity", "copula-location",
								"copula-role" }).contains(value)) {
					// got one
					foundLeft[0] = true;
				}
			}

			if (foundLeft[0]) {
				if (Arrays.asList(new String[] { "np-number", "np-person" }).contains(name)) {
					if (Arrays.asList(
							new String[] { "num-dual", "num-pl", "num-sg", "person-first",
									"person-second", "person-third" }).contains(value)) {
						score += freq[0] * evidenceCount;
					}
				}
			}

			// Pair<String, String> key = new Pair<String, String>(name, value);
			// Integer freq = heuristicData.get(key);
			// if (freq == null) {
			// score += 0.0;
			// } else {
			// score += evidenceCount * freq;
			// }
		}

		return score;
	}

	public void updateCurrentState(FeatureExpressionGraphManager fegMan) throws SegmenterException {

	}

	public static void main(String[] args) throws Exception {
		Thread[] t = new Thread[8];
		for (int i = 0; i < 8; i++) {
			t[i] = new Thread() {
				public void run() {
					int x = 0;
					for (int i = 0; i < Integer.MAX_VALUE; i++) {
						x += i;
					}
					System.out.println("x=" + x);
				}
			};
			t[i].start();
		}

		for (int i = 0; i < 8; i++) {
			t[i].join();
		}
		System.out.println("DONE");
	}
}
