package edu.cmu.cs.lti.avenue.navigation.search.generation2;

import java.util.ArrayList;
import java.util.TreeSet;

import edu.cmu.cs.lti.avenue.navigation.featuredetection.inductive.ObservableSentencePair;

/**
 * A sequence of sentence that we might elicit from our bilingual person next
 * 
 * @author jon
 */
public class HypothesisSequence {
	private ArrayList<Hypothesis> hypotheses;
	private TreeSet<ObservableSentencePair> sentences = new TreeSet<ObservableSentencePair>();
	public double score;

	public HypothesisSequence(int nLookahead) {
		this.hypotheses = new ArrayList<Hypothesis>(nLookahead);
	}
	
	/**
	 * Copy constructor
	 * 
	 * @param other
	 */
	public HypothesisSequence(HypothesisSequence other) {
		this.hypotheses = new ArrayList<Hypothesis>(other.hypotheses);
		this.score = other.score;
	}

	/**
	 * Gets the first hypothesis that should be elicited to pursue this sequence
	 * 
	 * @return
	 */
	public Hypothesis getFirstHypothesis() {
		return hypotheses.get(0);
	}

	public void addHypothesis(Hypothesis hyp) {
		hypotheses.add(hyp);
		sentences.add(hyp.sent);
	}
	
	public ArrayList<Hypothesis> getHypotheses() {
		return hypotheses;
	}

	public boolean containsSentence(ObservableSentencePair sent) {
		return sentences.contains(sent);
	}
	
	public String toString() {
		StringBuilder builder = new StringBuilder();
		for(Hypothesis hyp : hypotheses) {
			builder.append(hyp.toString() + " ++++ ");
		}
		return builder.toString();
	}
}
