package edu.cmu.cs.lti.avenue.navigation.search.generation1;

import java.util.ArrayList;

import edu.cmu.cs.lti.avenue.corpus.SentencePair;
import edu.cmu.cs.lti.avenue.trees.smart.SmartTree;

public class Hypothesis implements Comparable<Hypothesis> {
	
	private SentencePair realization;
	private double score;
	private SmartTree featureStructure;
	private ArrayList<SentencePair> disallowedRealizations = new ArrayList<SentencePair>(0);
	
	private Hypothesis(SmartTree featureStructure) {
		this.featureStructure = featureStructure;
		this.score = Double.NEGATIVE_INFINITY;
	}
	
	public Hypothesis(SmartTree featureStructure, ArrayList<SentencePair> disallowedRealizations) {
		this(featureStructure);
		this.disallowedRealizations = disallowedRealizations;
	}
	
	public Hypothesis(SmartTree featureStructure, SentencePair realization) {
		this(featureStructure);
		this.realization = realization;
	}

	/**
	 * might be null if we have no realization
	 * @return
	 */
	public SentencePair getRealization() {
		return realization;
	}

	public void setRealization(SentencePair realization) {
		this.realization = realization;
	}

	public double getScore() {
		return score;
	}

	public void setScore(double score) {
		this.score = score;
	}

	public int compareTo(Hypothesis other) {
		return Double.compare(this.score, other.score);
	}

	public SmartTree getFeatureStructure() {
		return featureStructure;
	}

	public void setFeatureStructure(SmartTree featureStructure) {
		this.featureStructure = featureStructure;
	}

	public ArrayList<SentencePair> getDisallowedRealizations() {
		return disallowedRealizations;
	}

	public void setDisallowedRealizations(ArrayList<SentencePair> disallowedRealizations) {
		this.disallowedRealizations = disallowedRealizations;
	}
}
