package edu.cmu.cs.lti.avenue.navigation.search.generation1;

import edu.cmu.cs.lti.avenue.navigation.search.generation1.tables.ConfigurationException;

public class Blender {

	protected final String[] featureNames;
	protected final double[] weights;

	public Blender(String[] featureNames, double[] weights) throws ConfigurationException {
		if (featureNames.length != weights.length) {
			throw new ConfigurationException("Non-parallel feature names and weights.");
		}

		this.featureNames = featureNames;
		this.weights = weights;
	}

	public double blend(double[] values) {
		double result = 0.0;

		if (values.length != weights.length) {
			throw new RuntimeException("Length of value array must match length of weights array.");
		}

		for (int i = 0; i < values.length; i++) {
			result += values[i] * weights[i];
		}

		return result;
	}
}
