package edu.cmu.cs.lti.avenue.navigation.search.generation1;

import edu.cmu.cs.lti.avenue.navigation.search.generation1.tables.ConfigurationException;

public class ArithmeticBlender extends Blender {

	public ArithmeticBlender(double averageWeight, double maxWeight, double productWeight,
			double sumWeight) throws ConfigurationException {
		
		super(new String[] { "AVERAGE", "MAX", "PRODUCT", "SUM" }, new double[] { averageWeight,
				maxWeight, productWeight, sumWeight });
	}

	public double blend(double average, double max, double product, double sum) {
		return average * super.weights[0] + max * super.weights[1] + product * super.weights[2]
				+ sum * super.weights[3];
	}

}
