package edu.cmu.cs.lti.avenue.navigation.featuredetection.inductive.simulation;

import java.util.ArrayList;
import java.util.List;

public class SimulationResult {

	private List<SimulatedArc> createdArcs;
	private List<SimulatedNode> createdNodes;

	public SimulationResult() {
		createdArcs = new ArrayList<SimulatedArc>();
		createdNodes = new ArrayList<SimulatedNode>();
	}

	public SimulationResult(List<SimulatedArc> createdArcs, List<SimulatedNode> createdNodes) {
		this.createdNodes = createdNodes;
		this.createdArcs = createdArcs;
	}

	public List<SimulatedNode> getCreatedNodes() {
		return createdNodes;
	}

	public List<SimulatedArc> getCreatedArcs() {
		return createdArcs;
	}

	public void add(SimulationResult result) {
		this.createdArcs.addAll(result.createdArcs);
		this.createdNodes.addAll(result.createdNodes);
	}

	public String toString() {

		StringBuilder builder = new StringBuilder();
		
		for (SimulatedArc arc : createdArcs) {
			builder.append(arc + " & ");
		}
		for (SimulatedNode node : createdNodes) {
			builder.append(node + " & ");
		}
		
		return builder.toString();
	}
}
