package edu.cmu.cs.lti.avenue.navigation.featuredetection.inductive.simulation;

// TODO: Add current entropy information to SimulatedNode
public class SimulatedNode {

	private String featureName;
	private String featureValue;
	private int evidenceCount;

	public SimulatedNode(String featureName, String featureValue, int evidenceCount) {
		this.featureName = featureName;
		this.featureValue = featureValue;
		this.evidenceCount = evidenceCount;
	}

	/**
	 * Gets the "crossed" feature name (which could contain multiple features if
	 * the value of nInteractions is > 1)
	 * 
	 * @return
	 */
	public String getFeatureName() {
		return featureName;
	}

	/**
	 * Gets the "crossed" feature value (which could contain multiple features
	 * if the value of nInteractions is > 1)
	 * 
	 * @return
	 */
	public String getFeatureValue() {
		return featureValue;
	}

	public int getEvidenceCount() {
		return evidenceCount;
	}

	public String toString() {
		return "NODE:" + featureName + ":" + featureValue + "=" + evidenceCount;
	}
}
