package edu.cmu.cs.lti.avenue.navigation.featuredetection.inductive.simulation;

// TODO: Add current entropy information to SimulatedNode
public class SimulatedArc {

	private String featureName;
	private String featureValueA;
	private String featureValueB;
	private int evidenceCount;

	public SimulatedArc(String featureName, String featureValueA, String featureValueB,
			int evidenceCount) {

		this.featureName = featureName;
		this.featureValueA = featureValueA;
		this.featureValueB = featureValueB;
		this.evidenceCount = evidenceCount;
	}

	/**
	 * Gets the "crossed" feature name (which could contain multiple features if
	 * the value of nInteractions is > 1)
	 * 
	 * @return
	 */
	public String getFeatureName() {
		return featureName;
	}

	/**
	 * Gets the "crossed" feature value (which could contain multiple features
	 * if the value of nInteractions is > 1)
	 * 
	 * @return
	 */
	public String getFeatureValueA() {
		return featureValueA;
	}

	/**
	 * Gets the "crossed" feature value (which could contain multiple features
	 * if the value of nInteractions is > 1)
	 * 
	 * @return
	 */
	public String getFeatureValueB() {
		return featureValueB;
	}

	public int getEvidenceCount() {
		return evidenceCount;
	}

	public String toString() {
		return "ARC:" + featureName + ":" + featureValueA + "+" + featureValueB + "=" + evidenceCount;
	}
}
