package edu.cmu.cs.lti.avenue.navigation.featuredetection.inductive.reports;

import info.jonclark.util.StringUtils;
import info.jonclark.util.TransformException;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

import edu.cmu.cs.lti.avenue.corpus.CorpusException;
import edu.cmu.cs.lti.avenue.featurespecification.FeatureValueSpec;
import edu.cmu.cs.lti.avenue.morphology.SegmenterException;
import edu.cmu.cs.lti.avenue.navigation.featuredetection.inductive.ExpressedTheme;
import edu.cmu.cs.lti.avenue.navigation.featuredetection.inductive.ExpressedThemeManager;
import edu.cmu.cs.lti.avenue.navigation.featuredetection.inductive.FeatureExpressionGraph;
import edu.cmu.cs.lti.avenue.navigation.featuredetection.inductive.FeatureValueCluster;

public class CsvFeatureDetectionReport implements FeatureDetectionReport {

	private final PrintWriter out;
	private final ExpressedThemeManager themeMan;

	private final HashSet<String> excludedFeatures;
	private final HashSet<String> includedFeatures;

	public CsvFeatureDetectionReport(File outFile, boolean reportEmptyCategories,
			ExpressedThemeManager themeMan, HashSet<String> excludedFeature,
			HashSet<String> includedFeatures) throws IOException {

		this.excludedFeatures = excludedFeature;
		this.includedFeatures = includedFeatures;

		this.themeMan = themeMan;
		this.out = new PrintWriter(outFile);
	}

	public void addFEG(FeatureExpressionGraph feg) throws ParseException, TransformException,
			SegmenterException, CorpusException {

		for (FeatureValueCluster valueCluster : feg.getAllValueClusters()) {
			for (FeatureValueSpec value : valueCluster.getFeatureValues()) {

				ArrayList<String> markings = new ArrayList<String>();
				themeMan.addFeatureValueCluster(valueCluster);
				Collection<ExpressedTheme> themes = themeMan.getExpressedThemes(valueCluster);
				for (ExpressedTheme theme : themes) {
					markings.add(theme.getMorpheme().morpheme);
				}

				String section = value.getParent().section.name;
				String name = value.getParent().name;
				String strValue = value.getName();
				String always = valueCluster.isUnobserved() ? "" : "X";
				String sometimes = "";
				String unobserved = valueCluster.isUnobserved() ? "X" : "";

				ArrayList<String> sameAsList = new ArrayList<String>();
				for (FeatureValueSpec value2 : valueCluster.getFeatureValues()) {
					if (value != value2) {
						sameAsList.add(value2.getName());
					}
				}
				String sameAs = StringUtils.untokenize(sameAsList, ",");
				String onlyWhen = "";

				// TODO: we should know whether a word was added or changed...
				// right?

				String changedWord = "H"; // always guess that the changed
				// word was the head
				String addedFWord = "X"; // assume all added words are
				// function words
				String addedCWord = "";
				String addedOther = "X";
				String reordered = ""; // never try to detect reorderings
				String evidenceIds = ""; // this is only cosmetic
				String affixWord = StringUtils.untokenize(markings, ",");
				String comments = ""; // this is only cosmetic

				String[] line =
						{ section, name, strValue, always, sometimes, unobserved, sameAs, onlyWhen,
								changedWord, addedFWord, addedCWord, addedOther, reordered,
								evidenceIds, affixWord, comments };
				String strLine = StringUtils.untokenize(line, "\t");
				out.println(strLine);
			}
		}
	}

	public void close() throws FileNotFoundException, ParseException, TransformException {
		out.close();
	}
}
