package edu.cmu.cs.lti.avenue.navigation.featuredetection.inductive.matrices;

import edu.cmu.cs.lti.avenue.corpus.CorpusException;

/**
 * Implements a lower triangular matrix.
 * 
 * @author jon
 */
public class TriangularMatrixFloat {
	private final float[][] matrix;

	/**
	 * @param defaultValue
	 *            returned if position has not been previously set
	 * @param size
	 *            number of values (including the main diagonal) in the first
	 *            row
	 */
	public TriangularMatrixFloat(float defaultValue, int size) {
		matrix = new float[size][];
		for (int i = 0; i < matrix.length; i++) {
			matrix[i] = new float[size - i];
			for (int j = i + 1; j < matrix[i].length; j++) {
				matrix[i][j] = defaultValue;
			}
		}
	}

	public void set(int i, int j, float value) {
		matrix[i][j - i] = value;
	}

	@SuppressWarnings("unchecked")
	public float get(int i, int j) {
		return matrix[i][j - i];
	}

	public void clear() {

	}

	public void visit(MatrixVisitor visitor) throws CorpusException {
		for (int i = 0; i < matrix.length; i++) {
			for (int j = 0; j < matrix[i].length; j++) {
				visitor.visit(i, j + i);
			}
		}
	}
}
