package edu.cmu.cs.lti.avenue.navigation.featuredetection.inductive.matrices;

import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeMap;

import edu.cmu.cs.lti.avenue.corpus.CorpusException;
import edu.cmu.cs.lti.avenue.navigation.featuredetection.inductive.PlateauFunction;
import edu.cmu.cs.lti.avenue.navigation.featuredetection.inductive.evidence.ArcEvidence;
import edu.cmu.cs.lti.avenue.navigation.featuredetection.inductive.evidence.ArcEvidenceCluster;

/**
 * Has the same interface as a TriangularMatrix, but clusters evidence rather
 * than storing all instances.
 * 
 * @author jon
 */
public class TriangularMatrixEvidenceCluster<T extends ArcEvidence> {

	public static int nEntries = 0;

	protected final TreeMap<ArcEvidence, ArcEvidenceCluster<T>>[][] matrix;
	protected static final int SMALL_SIZE = 1;

	@SuppressWarnings("unchecked")
	private static final ArrayList EMPTY_LIST = new ArrayList(0);

	/**
	 * @param defaultValue
	 *            returned if position has not been previously set
	 */
	@SuppressWarnings("unchecked")
	public TriangularMatrixEvidenceCluster(int size) {
		matrix = (TreeMap<ArcEvidence, ArcEvidenceCluster<T>>[][]) new TreeMap[size][];
		for (int i = 0; i < matrix.length; i++) {
			matrix[i] = (TreeMap<ArcEvidence, ArcEvidenceCluster<T>>[]) new TreeMap[size - i];
		}
	}

	public void append(int i, int j, T value, PlateauFunction distancePenalty) throws CorpusException {

		if (matrix[i][j - i] == null) {
			matrix[i][j - i] = new TreeMap<ArcEvidence, ArcEvidenceCluster<T>>();
		}
		nEntries++;

		TreeMap<ArcEvidence, ArcEvidenceCluster<T>> clusters = matrix[i][j - i];

		// what is the optimal way to store/retrieve these here?

		// TODO: make sure equals gets called so that we can retrieve the right
		// cluster using the value, then add (iff it was found)
		ArcEvidenceCluster<T> cluster = clusters.get(value);
		if (cluster != null) {
			cluster.addEvidence(value, distancePenalty);
		} else {
			cluster = new ArcEvidenceCluster<T>(value, distancePenalty);
			matrix[i][j - i].put(value, cluster);
		}
	}

	@SuppressWarnings("unchecked")
	public Collection<ArcEvidenceCluster<T>> get(int i, int j) {

		// if(i > maxRow) {
		// throw new ArrayIndexOutOfBoundsException("i=" + i);
		// }
		// if(j > maxColumn) {
		// throw new ArrayIndexOutOfBoundsException("j=" + j);
		// }

		if (matrix[i][j - i] == null) {
			return (ArrayList<ArcEvidenceCluster<T>>) EMPTY_LIST;
		} else {
			return matrix[i][j - i].values();
		}
	}

	public void clear() {
		for (int i = 0; i < matrix.length; i++) {
			for (int j = 0; j < matrix[i].length; j++) {
				matrix[i][j] = null;
			}
		}
	}

	public void visit(MatrixVisitor visitor) throws CorpusException {
		for (int i = 0; i < matrix.length; i++) {
			for (int j = 0; j < matrix[i].length; j++) {
				visitor.visit(i, j + i);
			}
		}
	}
}
