package edu.cmu.cs.lti.avenue.navigation.featuredetection.inductive.matrices;

import java.util.ArrayList;

import edu.cmu.cs.lti.avenue.corpus.CorpusException;

/**
 * To be used for very sparse situations. Non-sparse uses will waste memory and
 * speed with this implementation.
 * 
 * @author jon
 */
public class TriangularMatrixArrayList<T> {

	public static int nEntries = 0;

	protected final ArrayList<T>[][] matrix;
	protected static final int SMALL_SIZE = 1;

	@SuppressWarnings("unchecked")
	private static final ArrayList EMPTY_LIST = new ArrayList(0);

	/**
	 * @param defaultValue
	 *            returned if position has not been previously set
	 */
	@SuppressWarnings("unchecked")
	public TriangularMatrixArrayList(int size) {
		matrix = (ArrayList<T>[][]) new ArrayList[size][];
		for (int i = 0; i < matrix.length; i++) {
			matrix[i] = (ArrayList<T>[]) new ArrayList[size - i];
		}
	}

	public void append(int i, int j, T value) {

		if (matrix[i][j - i] == null) {
			matrix[i][j - i] = new ArrayList<T>(SMALL_SIZE);
		}
		nEntries++;
		matrix[i][j - i].add(value);
	}

	@SuppressWarnings("unchecked")
	public ArrayList<T> get(int i, int j) {

		// if(i > maxRow) {
		// throw new ArrayIndexOutOfBoundsException("i=" + i);
		// }
		// if(j > maxColumn) {
		// throw new ArrayIndexOutOfBoundsException("j=" + j);
		// }

		if (matrix[i][j - i] == null) {
			return (ArrayList<T>) EMPTY_LIST;
		} else {
			return matrix[i][j - i];
		}
	}

	public void clear() {
		for (int i = 0; i < matrix.length; i++) {
			for (int j = 0; j < matrix[i].length; j++) {
				matrix[i][j] = null;
			}
		}
	}

	public void visit(MatrixVisitor visitor) throws CorpusException {
		for (int i = 0; i < matrix.length; i++) {
			for (int j = 0; j < matrix[i].length; j++) {
				visitor.visit(i, j + i);
			}
		}
	}
}
