package edu.cmu.cs.lti.avenue.navigation.featuredetection.inductive.matrices;

import it.unimi.dsi.fastutil.ints.Int2FloatRBTreeMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectRBTreeMap;

/**
 * To be used for very sparse situations. Non-sparse uses will waste memory and
 * speed with this implementation.
 * 
 * @author jon
 */
public class SparseMatrixFloat {
	private final Int2ObjectRBTreeMap<Int2FloatRBTreeMap> rows =
			new Int2ObjectRBTreeMap<Int2FloatRBTreeMap>();
	private final float defaultValue;
	private int maxRow = 0;
	private int maxColumn = 0;

	/**
	 * @param defaultValue
	 *            returned if position has not been previously set
	 */
	public SparseMatrixFloat(float defaultValue) {
		this.defaultValue = defaultValue;
	}

	public void set(int i, int j, float value) {
		
		maxRow = Math.max(maxRow, i);
		maxColumn = Math.max(maxColumn, j);
		
		Int2FloatRBTreeMap column = rows.get(i);
		if (column == null) {
			column = new Int2FloatRBTreeMap();
			column.defaultReturnValue(defaultValue);
			rows.put(i, column);
		}
		column.put(j, value);
	}

	@SuppressWarnings("unchecked")
	public float get(int i, int j) {
		
//		if(i > maxRow) {
//			throw new ArrayIndexOutOfBoundsException("i=" + i);
//		}
//		if(j > maxColumn) {
//			throw new ArrayIndexOutOfBoundsException("j=" + j);
//		}
		
		Int2FloatRBTreeMap column = rows.get(i);
		if (column != null) {
			return column.get(j);
		}
		return defaultValue;
	}
	
	public int getMaxRow() {
		return maxRow;
	}
	
	public int getMaxColumn() {
		return maxColumn;
	}
	
	public void clear() {
		rows.clear();
	}
}
