package edu.cmu.cs.lti.avenue.navigation.featuredetection.inductive.matrices;

import it.unimi.dsi.fastutil.ints.Int2ObjectRBTreeMap;

import java.util.ArrayList;

/**
 * To be used for very sparse situations. Non-sparse uses will waste memory and
 * speed with this implementation.
 * 
 * @author jon
 */
public class SparseMatrixArrayList <T> {
	
	public static int nRows = 0;
	public static int nCols = 0;
	public static int nEntries = 0;
	
	private final Int2ObjectRBTreeMap<Int2ObjectRBTreeMap<ArrayList<T>>> rows =
			new Int2ObjectRBTreeMap<Int2ObjectRBTreeMap<ArrayList<T>>>();
	private static final int SMALL_SIZE = 1;
	private int maxRow = 0;
	private int maxColumn = 0;

	@SuppressWarnings("unchecked")
	private static final ArrayList EMPTY_LIST = new ArrayList(0);

	/**
	 * @param defaultValue
	 *            returned if position has not been previously set
	 */
	public SparseMatrixArrayList() {
	}

	public void append(int i, int j, T value) {
		
		maxRow = Math.max(maxRow, i);
		maxColumn = Math.max(maxColumn, j);
		
		Int2ObjectRBTreeMap<ArrayList<T>> column = rows.get(i);
		if (column == null) {
			column = new Int2ObjectRBTreeMap<ArrayList<T>>();
			rows.put(i, column);
			nRows++;
		}
		ArrayList<T> list = column.get(j);
		if (list == null) {
			list = new ArrayList<T>(SMALL_SIZE);
			column.put(j, list);
			nCols++;
		}
		nEntries++;
		list.add(value);
	}

	@SuppressWarnings("unchecked")
	public ArrayList<T> get(int i, int j) {
		
//		if(i > maxRow) {
//			throw new ArrayIndexOutOfBoundsException("i=" + i);
//		}
//		if(j > maxColumn) {
//			throw new ArrayIndexOutOfBoundsException("j=" + j);
//		}
		
		Int2ObjectRBTreeMap<ArrayList<T>> column = rows.get(i);
		if (column != null) {
			ArrayList<T> list = column.get(j);
			if (list != null) {
				return list;
			}
		}
		return (ArrayList<T>) EMPTY_LIST;
	}
	
	public int getMaxRow() {
		return maxRow;
	}
	
	public int getMaxColumn() {
		return maxColumn;
	}
	
	public void clear() {
		rows.clear();
	}
}
