package edu.cmu.cs.lti.avenue.navigation.featuredetection.inductive.matrices;

import info.jonclark.util.FormatUtils;
import info.jonclark.util.StringUtils;

public class IntTriangularMatrixNoDiag {

	public abstract class IntTriangularMatrixNoDiagVisitor {
		public abstract void visit(int matrixElement, int i, int j);
	}

	private final int[][] matrix;

	@SuppressWarnings("unchecked")
	public IntTriangularMatrixNoDiag(int nLength) {
		matrix = new int[nLength][nLength];
	}

	public void visit(IntTriangularMatrixNoDiagVisitor visitor) {
		for (int i = 0; i < matrix.length - 1; i++) {
			for (int j = 0; j <= i; j++) {
				visitor.visit(matrix[i][j], i + 1, j);
			}
		}
	}

	public void add(IntTriangularMatrixNoDiag other) {
		assert this.matrix.length == other.matrix.length : "length mismatch";
		for (int i = 0; i < matrix.length - 1; i++) {
			assert this.matrix[i].length == other.matrix[i].length : "internal length mismatch";
			for (int j = 0; j <= i; j++) {
				this.matrix[i][j] += other.matrix[i][j];
			}
		}
	}

	public String toString() {

		StringBuilder builder = new StringBuilder();
		for (int i = 0; i <= matrix.length; i++) {
			for (int j = 0; j <= matrix.length; j++) {
				if (i > 0 && j < i) {
					double perc = matrix[i - 1][j];
					if (Double.isNaN(perc) || Double.isInfinite(perc)) {
						// make sure our table lines up
						StringUtils.forceNumberLength(perc + "", 8);
						builder.append(perc + "\t");
					} else {
						builder.append(FormatUtils.formatDoubleExp(perc) + "\t");
					}
				} else {
					builder.append("--------\t");
				}
			}
			builder.append("\n");
		}
		return builder.toString();
	}
}
