package edu.cmu.cs.lti.avenue.navigation.featuredetection.inductive.evidence;

import java.io.Serializable;
import java.util.List;

import edu.cmu.cs.lti.avenue.morphology.Paradigm;

/**
 * A morpheme (one piece of a segmented word) including information about its
 * associated Paradigms and the original word it came from.
 * 
 * @author jon
 */
public class ObservedMorpheme implements Comparable<ObservedMorpheme>, Serializable {

	private static final long serialVersionUID = -6501742901957890406L;

	public List<Paradigm> paradigms;
	public String morpheme;
	public String[] segmentedWord;
	public boolean markedOnMe;
	public boolean markedOnMyDependent;
	public boolean markedOnMyGovernor;

	public ObservedMorpheme(List<Paradigm> paradigms, String morpheme, String[] segmentedWord,
			boolean markedOnMe, boolean markedOnMyDependent, boolean markedOnMyGovernor) {
		
		this.paradigms = paradigms;
		this.morpheme = morpheme;
		this.segmentedWord = segmentedWord;
		this.markedOnMe = markedOnMe;
		this.markedOnMyDependent = markedOnMyDependent;
		this.markedOnMyGovernor = markedOnMyGovernor;
	}

	public int hashCode() {
		return morpheme.hashCode();
	}

	public boolean equals(Object obj) {
		if (obj instanceof ObservedMorpheme) {
			ObservedMorpheme other = (ObservedMorpheme) obj;
			return this.morpheme.equals(other.morpheme) && this.paradigms.equals(other.paradigms);
		} else {
			return false;
		}
	}

	public int compareTo(ObservedMorpheme o) {
		return this.morpheme.compareTo(o.morpheme);
	}

	public String getMarkedOnString() {
		StringBuilder result = new StringBuilder();
		if(markedOnMe) {
			result.append("ME, ");
		}
		if(markedOnMyDependent) {
			result.append("MY_DEPENDENT, ");
		}
		if(markedOnMyGovernor) {
			result.append("MY_GOVERNOR, ");
		}
		if(!markedOnMe && !markedOnMyDependent && !markedOnMyGovernor) {
			result.append("OTHER, ");
		}
		return result.toString();
	}
	
	public String toString() {
		return morpheme;
	}
}
