package edu.cmu.cs.lti.avenue.navigation.featuredetection.inductive.evidence;

import info.jonclark.util.StringUtils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

import edu.cmu.cs.lti.avenue.corpus.SentencePair;

/**
 * Stores the evidence on an Node recording what distinguishes how a single
 * feature value is expressed as compared to other values (nodes) within the
 * same feature. There will be one NodeEvidence instance per unique set of words
 * that differ between any 2 minimal pairs. For example, comparing "a el gato
 * bueno" and "a los gatos" would result in a two NodeEvidence instances: 1)
 * with the added words "el" and "gato" plus another instance 2) with the added
 * words "los" and "gatos"
 * 
 * @author jon
 */
public class NodeEvidence {

	private ArrayList<ArcEvidenceCluster<FeatureMarking>> arcEvidenceClusters =
			new ArrayList<ArcEvidenceCluster<FeatureMarking>>();
	private Set<String> addedWords;
	private Set<ObservedMorpheme> addedMorphemes;
	private String addedWordsString = null;
	private String hashString = null;
	private SentencePair pair;
	private int frequency = 0;
	private float weightedFrequency = 0.0f;

	public NodeEvidence(Set<String> addedWords, Set<ObservedMorpheme> addedMorphemes,
			SentencePair pair) {

		this.addedWords = addedWords;
		this.addedMorphemes = addedMorphemes;
		this.pair = pair;
	}

	public Set<String> getAddedWords() {
		return addedWords;
	}

	public Set<ObservedMorpheme> getAddedMorphemes() {
		return addedMorphemes;
	}

	public String getAddedWordsString() {
		if (addedWordsString == null) {
			ArrayList<String> aw = new ArrayList<String>(getAddedWords());
			Collections.sort(aw);
			addedWordsString = StringUtils.untokenize(aw, "_");
		}
		return addedWordsString;
	}

	public String hashString() {
		if (hashString == null) {
			hashString = getAddedWordsString();
		}
		return hashString;
	}

	public SentencePair getPair() {
		return pair;
	}

	public String toLatexString() {
		throw new Error("TODO: Implement NodeEvidence.toLatexString();");
	}

	public void addFeatureMarking(ArcEvidenceCluster<FeatureMarking> cluster) {
		arcEvidenceClusters.add(cluster);
		frequency += cluster.getAbsoluteFrequency();
		weightedFrequency += cluster.getWeightedFrequency();
	}

	public int getAbsoluteFrequency() {
		return frequency;
	}
	
	public float getWeightedFrequency() {
		return weightedFrequency;
	}

	public List<ArcEvidenceCluster<FeatureMarking>> getArcEvidenceClusters() {
		return arcEvidenceClusters;
	}
}
