package edu.cmu.cs.lti.avenue.navigation.featuredetection.inductive.evidence;

import info.jonclark.util.LatexUtils;
import info.jonclark.util.StringUtils;

import java.util.TreeSet;

import edu.cmu.cs.lti.avenue.corpus.SentencePair;
import edu.cmu.cs.lti.avenue.morphology.Segmenter;
import edu.cmu.cs.lti.avenue.navigation.featuredetection.inductive.FeatureValueInteraction;

public class FeatureSimilarity extends ArcEvidence {
	private final SentencePair pairA;
	private final SentencePair pairB;
	private final FeatureValueInteraction featureValueA;
	private final FeatureValueInteraction featureValueB;

	private static final TreeSet<String> EMPTY_SET = new TreeSet<String>();
	private static final TreeSet<ObservedMorpheme> EMPTY_MORPHEME_SET =
			new TreeSet<ObservedMorpheme>();

	private int hashCode = -1;

	public FeatureSimilarity(SentencePair pairA, SentencePair pairB,
			FeatureValueInteraction featureValueA, FeatureValueInteraction featureValueB) {

		this.pairA = pairA;
		this.pairB = pairB;
		this.featureValueA = featureValueA;
		this.featureValueB = featureValueB;
	}

	public SentencePair getPairA() {
		return pairA;
	}

	public SentencePair getPairB() {
		return pairB;
	}

	public FeatureValueInteraction getFeatureValueA() {
		return featureValueA;
	}

	public FeatureValueInteraction getFeatureValueB() {
		return featureValueB;
	}

	public int hashCode() {
		if (hashCode == -1) {
			hashCode =
					pairA.getMyLine().hashCode() ^ pairB.getMyLine().hashCode()
							^ featureValueA.getName().hashCode()
							^ featureValueB.getName().hashCode();
		}
		return hashCode;
	}

	public boolean equals(Object obj) {
		if (obj instanceof ArcEvidence) {
			ArcEvidence other = (ArcEvidence) obj;
			return this.pairA == other.getPairA() && this.pairB == other.getPairB()
					&& this.featureValueA == other.getFeatureValueA()
					&& this.featureValueB == other.getFeatureValueB();
		} else {
			return false;
		}
	}

	public String toLatexString() {
		String[] arrTargetA = pairA.getNormalizedTargetTokens();
		String[] arrTargetB = pairB.getNormalizedTargetTokens();

		int nColumns = Math.max(arrTargetA.length, arrTargetB.length) + 2;
		StringBuilder builder =
				new StringBuilder("\\begin{tabular}{"
						+ StringUtils.duplicateCharacter('c', nColumns) + "}\n");

		builder.append(featureValueA.getName() + ": & ");
		for (int i = 0; i < arrTargetA.length; i++) {
			builder.append(clean(arrTargetA[i]));
			builder.append(" & ");
		}

		// make sure translations line up
		for (int i = arrTargetA.length; i < nColumns - 2; i++) {
			builder.append(" & ");
		}
		builder.append("(" + pairA.getDisplaySourceSentence() + ") sentnum: " + pairA.getId()
				+ " \\\\ \n");

		builder.append(featureValueB.getName() + ": & ");
		for (int i = 0; i < arrTargetB.length; i++) {
			builder.append(clean(arrTargetB[i]));
			builder.append(" & ");
		}

		// make sure translations line up
		for (int i = arrTargetB.length; i < nColumns - 2; i++) {
			builder.append(" & ");
		}
		builder.append("(" + pairB.getDisplaySourceSentence() + ") sentnum: " + pairB.getId()
				+ " \\\\ \n");
		builder.append("\\hline");
		builder.append("\\end{tabular}\n");
		return builder.toString();
	}

	private static String clean(String s) {
		return LatexUtils.replaceLatexKillers(s);
	}

	public String toString() {
		return featureValueA.getName() + ": " + pairA.toString() + " is the same as "
				+ featureValueB.getName() + ": " + pairB.toString();
	}

	public TreeSet<String> getAddedWordsA() {
		return EMPTY_SET;
	}

	public TreeSet<String> getAddedWordsB() {
		return EMPTY_SET;
	}

	public String getAddedWordsStringA() {
		return "";
	}

	public String getAddedWordsStringB() {
		return "";
	}

	public TreeSet<String> getReorderedWords() {
		return EMPTY_SET;
	}

	public String getReorderedWordsString() {
		return "";
	}

	@Override
	public TreeSet<ObservedMorpheme> getAddedMorphemesA(Segmenter segmenter) {
		return EMPTY_MORPHEME_SET;
	}

	@Override
	public TreeSet<ObservedMorpheme> getAddedMorphemesB(Segmenter segmenter) {
		return EMPTY_MORPHEME_SET;
	}
}
