package edu.cmu.cs.lti.avenue.navigation.featuredetection.inductive.evidence;

import java.util.TreeSet;

import edu.cmu.cs.lti.avenue.corpus.CorpusException;
import edu.cmu.cs.lti.avenue.corpus.SentencePair;
import edu.cmu.cs.lti.avenue.morphology.Segmenter;
import edu.cmu.cs.lti.avenue.morphology.SegmenterException;
import edu.cmu.cs.lti.avenue.navigation.featuredetection.inductive.FeatureValueInteraction;
import edu.cmu.cs.lti.avenue.navigation.featuredetection.inductive.PlateauFunction;

/**
 * Stores the evidence on an Arc, which shows how 2 feature values are the same
 * or different than each other. Unlike the ArcEvidence class, an ArcE
 * 
 * @author jon
 * @param <T>
 */
public class ArcEvidenceCluster<T extends ArcEvidence> extends ArcEvidence {

	private ArcEvidence representativeMarking;
	// private final ArrayList<Evidence> markings = new ArrayList<Evidence>();
	private int frequency = 0;
	private float weightedFrequency = 0.0f;

	public ArcEvidenceCluster(ArcEvidence firstMarking, PlateauFunction distancePenalty) {
		// markings.add(firstMarking);
		representativeMarking = firstMarking;
		frequency++;
		weightedFrequency += getWeightedFreq(firstMarking, distancePenalty);
	}

	private static float getWeightedFreq(ArcEvidence marking, PlateauFunction distancePenalty) {
		int absoluteDistance = Math.abs(marking.getPairA().getId() - marking.getPairB().getId());
		return (float) distancePenalty.getScalingFactor(absoluteDistance);
	}

	public void addEvidence(ArcEvidence marking, PlateauFunction distancePenalty)
			throws CorpusException {

		assert representativeMarking.getFeatureValueA() == marking.getFeatureValueA() : "feature mismatch: "
				+ representativeMarking.getFeatureValueA() + " vs " + marking.getFeatureValueA();
		assert representativeMarking.getFeatureValueB() == marking.getFeatureValueB() : "feature mismatch"
				+ representativeMarking.getFeatureValueB() + " vs " + marking.getFeatureValueB();

		double currentWeight = getWeightedFreq(representativeMarking, distancePenalty);
		double newWeight = getWeightedFreq(marking, distancePenalty);
		if (newWeight > currentWeight) {
			representativeMarking = marking;
		}

		// only count the number of markings rather than storing them all
		frequency++;
		weightedFrequency += newWeight;

		// keep the shorter sentence as our representative marking
		// int nCurLen =
		// representativeMarking.getPairA().getNormalizedTargetTokens().length
		// +
		// representativeMarking.getPairB().getNormalizedTargetTokens().length;
		// int nNewLen =
		// marking.getPairA().getNormalizedTargetTokens().length
		// + marking.getPairB().getNormalizedTargetTokens().length;
		// if (nNewLen < nCurLen) {
		// representativeMarking = marking;
		// }
	}

	public int getAbsoluteFrequency() {
		return frequency;
	}

	public float getWeightedFrequency() {
		return weightedFrequency;
	}

	// public boolean isLike(Evidence other) {
	// String otherReordered = other.getReorderedWordsString();
	// String otherAdded = other.getAddedWordsString();
	//
	// // take advantage of intern()ed strings
	// return getReorderedWordsString().equals(otherReordered)
	// && getAddedWordsString().equals(otherAdded);
	// }
	//
	// public String getReorderedWordsString() {
	// return representativeMarking.getReorderedWordsString();
	// }
	//
	// public String getAddedWordsStringA() {
	// return representativeMarking.getAddedWordsStringA();
	// }
	//
	// public String getAddedWordsStringB() {
	// return representativeMarking.getAddedWordsStringB();
	// }
	//
	// public String getName() {
	// return representativeMarking.getAddedWordsStringA() + "&"
	// + representativeMarking.getAddedWordsStringB();
	// }

	public ArcEvidence getRepresentativeMarking() {
		return representativeMarking;
	}

	public TreeSet<String> getAddedWordsA() throws CorpusException {
		return representativeMarking.getAddedWordsA();
	}

	public TreeSet<String> getAddedWordsB() throws CorpusException {
		return representativeMarking.getAddedWordsB();
	}

	public TreeSet<String> getReorderedWords() throws CorpusException {
		return representativeMarking.getReorderedWords();
	}

	public SentencePair getPairA() {
		return representativeMarking.getPairA();
	}

	public SentencePair getPairB() {
		return representativeMarking.getPairB();
	}

	public FeatureValueInteraction getFeatureValueA() {
		return representativeMarking.getFeatureValueA();
	}

	public FeatureValueInteraction getFeatureValueB() {
		return representativeMarking.getFeatureValueB();
	}

	public String toLatexString() throws CorpusException {
		return "count = " + frequency + " \\\\ \n" + representativeMarking.toLatexString();
	}

	@Override
	public TreeSet<ObservedMorpheme> getAddedMorphemesA(Segmenter segmenter)
			throws SegmenterException, CorpusException {
		return representativeMarking.getAddedMorphemesA(segmenter);
	}

	@Override
	public TreeSet<ObservedMorpheme> getAddedMorphemesB(Segmenter segmenter)
			throws SegmenterException, CorpusException {
		return representativeMarking.getAddedMorphemesB(segmenter);
	}
}
