package edu.cmu.cs.lti.avenue.navigation.featuredetection.inductive.evidence;

import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

import edu.cmu.cs.lti.avenue.corpus.CorpusException;
import edu.cmu.cs.lti.avenue.corpus.SentencePair;
import edu.cmu.cs.lti.avenue.morphology.Segmenter;
import edu.cmu.cs.lti.avenue.morphology.SegmenterException;
import edu.cmu.cs.lti.avenue.navigation.featuredetection.inductive.FeatureValueInteraction;

/**
 * Stores the evidence on an Arc, which shows how 2 feature values are the same
 * or different than each other; This class and its implementors are one of the
 * most-created classes in feature detection, making memory-efficient
 * representation of their data critical.
 * 
 * @author jon
 */
public abstract class ArcEvidence implements Comparable<ArcEvidence> {

	public abstract TreeSet<String> getReorderedWords() throws CorpusException;

	public abstract TreeSet<String> getAddedWordsA() throws CorpusException;

	public abstract TreeSet<String> getAddedWordsB() throws CorpusException;

	public abstract TreeSet<ObservedMorpheme> getAddedMorphemesA(Segmenter segmenter)
			throws SegmenterException, CorpusException;

	public abstract TreeSet<ObservedMorpheme> getAddedMorphemesB(Segmenter segmenter)
			throws SegmenterException, CorpusException;

	// public abstract String getAddedWordsStringA();
	//
	// public abstract String getAddedWordsStringB();
	//
	// public abstract String getReorderedWordsString();
	//
	// private String hashString = null;
	//
	// /**
	// * Returns a unique value based on added and reordered words. If the hash
	// * strings for two ArcEvidence classes are the same, then no new symbolic
	// * information is gained from that evidence; the benefit of the additional
	// * evidence is purely statistical.
	// *
	// * @return
	// */
	// public String hashString() {
	// if (hashString == null) {
	// hashString =
	// getReorderedWordsString() + "_" + getAddedWordsStringA() + "_"
	// + getAddedWordsStringB();
	// }
	// return hashString;
	// }

	private int hash = -1;

	public int hashCode() {
		if (hash == -1) {
			try {
				for (String str : getReorderedWords()) {
					hash ^= str.hashCode();
				}
				for (String str : getAddedWordsA()) {
					hash ^= str.hashCode();
				}
				for (String str : getAddedWordsB()) {
					hash ^= str.hashCode();
				}
			} catch (CorpusException e) {
				throw new RuntimeException(e);
			}
		}
		return hash;
	}

	public boolean equals(Object obj) {
		if (obj instanceof ArcEvidence) {
			ArcEvidence other = (ArcEvidence) obj;
			try {
				return this.getReorderedWords().equals(other.getReorderedWords())
						&& this.getAddedWordsA().equals(other.getAddedWordsA())
						&& this.getAddedWordsB().equals(other.getAddedWordsB());
			} catch (CorpusException e) {
				throw new RuntimeException(e);
			}
		} else {
			return false;
		}
	}

	public static <T extends Comparable<T>> int compare(List<T> a, List<T> b) {

		// first see if the list lengths are unequal
		if (a.size() > b.size()) {
			return -1;
		} else if (a.size() < b.size()) {
			return 1;
		} else {
			// same lists sizes, check for the first non-equal element and
			// return that comparison as our result
			for (int i = 0; i < a.size(); i++) {
				int result = a.get(i).compareTo(b.get(i));
				if (result != 0)
					return result;
			}

			// nothing was different
			return 0;
		}
	}

	public static <T extends Comparable<T>> int compare(SortedSet<T> setA, SortedSet<T> setB) {

		// first see if the list lengths are unequal
		if (setA.size() > setB.size()) {
			return -1;
		} else if (setA.size() < setB.size()) {
			return 1;
		} else {

			// same lists sizes, check for the first non-equal element and
			// return that comparison as our result

			Iterator<T> itA = setA.iterator();
			Iterator<T> itB = setB.iterator();

			while (itA.hasNext()) {
				T a = itA.next();
				T b = itB.next();
				int result = a.compareTo(b);
				if (result != 0) {
					return result;
				}
			}

			// nothing was different
			return 0;
		}
	}

	public int compareTo(ArcEvidence other) {

		try {
			int result = compare(this.getReorderedWords(), other.getReorderedWords());
			if (result != 0)
				return result;

			result = compare(this.getAddedWordsA(), this.getAddedWordsA());
			if (result != 0)
				return result;

			result = compare(this.getAddedWordsB(), this.getAddedWordsB());
			return result;
		} catch (CorpusException e) {
			throw new RuntimeException(e);
		}
	}

	public abstract SentencePair getPairA();

	public abstract SentencePair getPairB();

	public abstract FeatureValueInteraction getFeatureValueA();

	public abstract FeatureValueInteraction getFeatureValueB();

	public abstract String toLatexString() throws CorpusException;
}
