package edu.cmu.cs.lti.avenue.navigation.featuredetection.inductive;

public class PlateauFunction {

	private final int noPenaltyDistance;
	private final int somePenaltyDistance;

	public PlateauFunction(int noPenaltyDistance, int somePenaltyDistance) {
		this.noPenaltyDistance = noPenaltyDistance;
		this.somePenaltyDistance = somePenaltyDistance;
	}

	public double getScalingFactor(int absoluteDistance) {
		if (absoluteDistance <= noPenaltyDistance) {
			return 1.0;
		} else if (absoluteDistance <= somePenaltyDistance) {
			return 1.0 - Math.pow((((double) 1 / (double) somePenaltyDistance) * absoluteDistance),
					2);
		} else {
			return 0.0;
		}
	}

	public static void main(String[] args) throws Exception {
		PlateauFunction func = new PlateauFunction(100, 400);
		for (int i = 0; i <= 1000; i++) {
			System.out.println(i + " " + func.getScalingFactor(i));
		}
	}
}
