package edu.cmu.cs.lti.avenue.navigation.featuredetection.inductive;

import java.util.List;

import edu.cmu.cs.lti.avenue.corpus.SentencePair;

/**
 * A sentence pair that has the necessary information for feature detection
 * pre-calculated and cached..
 * 
 * @author jon
 */
public class ObservableSentencePair implements Comparable<ObservableSentencePair> {

	private SentencePair sent;
	private List<MinimalPairMapping> minPairMappings;

	public ObservableSentencePair(SentencePair sent, List<MinimalPairMapping> minPairMappings) {
		this.sent = sent;
		this.minPairMappings = minPairMappings;
	}

	public SentencePair getSentencePair() {
		return sent;
	}

	public List<MinimalPairMapping> getMinPairMappings() {
		return minPairMappings;
	}

	public int hashCode() {
		return sent.hashCode();
	}

	public boolean equals(Object obj) {
		if (obj instanceof ObservableSentencePair) {
			ObservableSentencePair other = (ObservableSentencePair) obj;
			return this.sent.equals(other.sent);
		} else {
			return false;
		}
	}

	public String toString() {
		return sent.toString();
	}

	public int compareTo(ObservableSentencePair o) {
		return this.sent.compareTo(o.sent);
	}
}
