package edu.cmu.cs.lti.avenue.navigation.featuredetection.inductive;

import info.jonclark.util.StringUtils;
import edu.cmu.cs.lti.avenue.featurespecification.FeatureContext;
import edu.cmu.cs.lti.avenue.trees.smart.SmartTreeDelta;

/**
 * A container for a particular match of a Wildcard Feature Structures (WFS) and
 * its associated information. Note that a MinimalPairMapping represents a
 * possible minimal pair, though no compatible sentence may exist to form a
 * minimal pair. Also, while the featureNames should be the same for all
 * MinimalPairMappings in the eventual MinimalCluster, there may be many
 * featureValues, depending on the particular SentencePair instance that matches
 * this WFS. MinimalPairMappings are typically generated by
 * MinimalPairManager.mapToMinimalPairs().
 * 
 * @author jon
 */
public class MinimalPairMapping {

	public int id;
	public String[] featureNames;
	public String[] featureValues;
	public SmartTreeDelta wildcardFeatureStructure;
	public FeatureContext featureContext;

	public MinimalPairMapping(int id, String[] featureNames, String[] featureValues,
			SmartTreeDelta wildcardFeatureStructure, FeatureContext featureContext) {

		this.id = id;
		this.featureNames = featureNames;
		this.featureValues = featureValues;
		this.wildcardFeatureStructure = wildcardFeatureStructure;
		this.featureContext = featureContext;
	}

	public boolean equals(Object obj) {
		if (obj instanceof MinimalPairMapping) {
			MinimalPairMapping mapping = (MinimalPairMapping) obj;
			return this.id == mapping.id;
		} else {
			return false;
		}
	}

	public String toString() {
		return id + "::" + StringUtils.untokenize(featureNames, "X") + "::"
				+ StringUtils.untokenize(featureValues, "X") + "::" + featureContext.toString();
	}
}
