package edu.cmu.cs.lti.avenue.navigation.featuredetection.inductive;

import info.jonclark.log.LogUtils;
import info.jonclark.util.StringUtils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Logger;

public class InductiveResultRow {

	private static final Logger log = LogUtils.getLogger();

	public String section;
	public String name;
	public String value;
	public boolean always;
	public boolean sometimes;
	public boolean unobserved;
	public String[] sameAs;
	public String when;
	public boolean changedWord;
	public char markedOn;
	public boolean addedFWord;
	public boolean addedCWord;
	public boolean addedOther;
	public boolean reorder;
	public int[] evidenceIds;
	public String[] morphemes;
	public String[] words;
	public String[] affixes;
	public String comments;

	public InductiveResultRow(String row, String file, int nLine) {
		row = StringUtils.replaceFast(row, "\"", "");
		String[] filledTokens = StringUtils.split(row, "\t", 16);
		String[] tok = new String[16];
		Arrays.fill(tok, "");
		System.arraycopy(filledTokens, 0, tok, 0, filledTokens.length);

		section = tok[0].trim();
		name = tok[1].trim();
		value = tok[2].trim();
		always = tok[3].trim().equalsIgnoreCase("x");
		sometimes = tok[4].trim().equalsIgnoreCase("x");
		unobserved = tok[5].trim().equalsIgnoreCase("x");
		sameAs = StringUtils.tokenize(tok[6], ",");
		when = tok[7].trim();
		changedWord =
				tok[8].trim().equalsIgnoreCase("g") || tok[8].trim().equalsIgnoreCase("h")
						|| tok[8].trim().equalsIgnoreCase("d");
		markedOn = changedWord ? tok[8].trim().charAt(0) : ' ';
		addedFWord = tok[9].trim().equalsIgnoreCase("x");
		addedCWord = tok[10].trim().equalsIgnoreCase("x");
		addedOther = tok[11].trim().equalsIgnoreCase("x");
		reorder = tok[12].trim().equalsIgnoreCase("x");

		if (StringUtils.isComposedOf(tok[13], "1234567890, ")) {
			evidenceIds = StringUtils.toIntArray(StringUtils.tokenize(tok[13], ","));
		} else {
			evidenceIds = new int[0];
			log.warning("Ignoring non-numeric evidence ID's in gold standard (" + file + ":"
					+ nLine + "): " + tok[13]);
		}

		tok[14] = tok[14].toLowerCase();
		morphemes = StringUtils.tokenize(tok[14], ",/. ");
		StringUtils.trimTokens(morphemes);
		// if (morphemes.length > 0)
		// System.out.println("Adding " + morphemes.length + " morphemes: " +
		// tok[14]);
		comments = tok[15].trim();

		ArrayList<String> affixes = new ArrayList<String>();
		ArrayList<String> words = new ArrayList<String>();
		for (final String morpheme : morphemes) {
			if (morpheme.startsWith("-") || morpheme.endsWith("-")) {
				affixes.add(morpheme);
			} else {
				words.add(morpheme);
			}
		}
		this.affixes = affixes.toArray(new String[affixes.size()]);
		this.words = words.toArray(new String[words.size()]);
	}

	private static String untokenize(String... s) {
		return StringUtils.untokenize(s, "\t");
	}

	private static String x(boolean b) {
		return b ? "X" : "";
	}

	public String toString() {
		return untokenize(section, name, value, x(always), x(sometimes), x(unobserved),
				StringUtils.untokenize(sameAs, ","), when, markedOn + "", x(addedFWord),
				x(addedCWord), x(addedOther), x(reorder), StringUtils.untokenize(evidenceIds, ","),
				StringUtils.untokenize(morphemes, ","), comments);
	}
}
