package edu.cmu.cs.lti.avenue.navigation.featuredetection.inductive;

import edu.cmu.cs.lti.avenue.featurespecification.FeatureValueSpec;

/**
 * A group of feature values that is being simultaneously analyzed as a group.
 * In this way, we can see if they "interact" or contain mutual information
 * about one another.
 * 
 * @author jon
 */
public class FeatureValueInteraction {
	public final FeatureInteraction parent;
	public final FeatureValueSpec[] featureValueSpecs;
	private String name;

	public FeatureValueInteraction(FeatureInteraction parent, FeatureValueSpec[] valueSpecs) {
		this.parent = parent;
		this.featureValueSpecs = valueSpecs;
	}

	public static String crossValues(FeatureValueSpec[] featureValueSpecs) {
		StringBuilder builder = new StringBuilder();
		for (int i = 0; i < featureValueSpecs.length; i++) {
			builder.append(featureValueSpecs[i].getName());
			if (i < featureValueSpecs.length - 1) {
				builder.append(FeatureInteraction.X);
			}
		}
		return builder.toString();
	}

	public FeatureInteraction getParent() {
		return parent;
	}

	public boolean equals(Object obj) {
		if (obj instanceof FeatureValueInteraction) {
			FeatureValueInteraction other = (FeatureValueInteraction) obj;
			return other.getName().equals(this.getName());
		} else {
			return false;
		}
	}

	public int hashCode() {
		return getName().hashCode();
	}

	public String getName() {
		if (name == null) {
			name = crossValues(featureValueSpecs);
		}
		return name;
	}

	public String toString() {
		return getName();
	}
}
