package edu.cmu.cs.lti.avenue.navigation.featuredetection.inductive;

import java.util.ArrayList;

import edu.cmu.cs.lti.avenue.featurespecification.FeatureContext;
import edu.cmu.cs.lti.avenue.featurespecification.FeatureSpec;
import edu.cmu.cs.lti.avenue.featurespecification.FeatureValueSpec;

public class FeatureInteraction {

	public static final String X = "X";

	public final FeatureContext featureContext;
	public final FeatureSpec[] featureSpecs;
	public final FeatureValueInteraction[] featureValueInteractions;
	public final String[] featureNames;
	public final String[] crossedValues;

	private String name;

	public FeatureInteraction(FeatureSpec[] featureSpecs, FeatureContext featureContext) {
		this.featureSpecs = featureSpecs;
		this.featureContext = featureContext;

		featureNames = new String[featureSpecs.length];
		for (int i = 0; i < featureSpecs.length; i++) {
			featureNames[i] = featureSpecs[i].name;
		}

		ArrayList<String> crossList = new ArrayList<String>();
		ArrayList<FeatureValueInteraction> valueInteractions =
				new ArrayList<FeatureValueInteraction>();
		FeatureValueSpec[] workingValues = new FeatureValueSpec[featureSpecs.length];
		boolean[] featureLocks = new boolean[featureSpecs.length];
		crossValues(crossList, valueInteractions, workingValues, featureLocks, 0);
		crossedValues = crossList.toArray(new String[crossList.size()]);
		featureValueInteractions =
				valueInteractions.toArray(new FeatureValueInteraction[valueInteractions.size()]);
	}

	private void crossValues(ArrayList<String> crossList,
			ArrayList<FeatureValueInteraction> valueInteractions, FeatureValueSpec[] workingValues,
			boolean[] featureLocks, int nDepth) {

		for (int i = 0; i < featureSpecs.length; i++) {
			// don't look at the same feature compared with itself
			if (!featureLocks[i]) {
				featureLocks[i] = true;

				for (int j = 0; j < featureSpecs[i].values.length; j++) {
					workingValues[nDepth] = featureSpecs[i].values[j];

					if (nDepth < featureSpecs.length - 1) {
						crossValues(crossList, valueInteractions, workingValues, featureLocks,
								nDepth + 1);
					} else {
						FeatureValueSpec[] copiedValues = new FeatureValueSpec[workingValues.length];
						System.arraycopy(workingValues, 0, copiedValues, 0, workingValues.length);
						FeatureValueInteraction interaction =
								new FeatureValueInteraction(this, copiedValues);
						String strCrossedValues = interaction.getName();
						crossList.add(strCrossedValues);
						valueInteractions.add(interaction);
					}
				}

				// put things back the way we found them
				featureLocks[i] = false;
			}
		}
	}

	public boolean containsFeature(String featureName) {
		for (final FeatureSpec spec : featureSpecs) {
			if (spec.name.equals(featureName)) {
				return true;
			}
		}
		return false;
	}

	public static String makeName(String featureContext, String[] featureValues) {
		StringBuilder builder = new StringBuilder(featureContext);
		builder.append(X);
		for (int i = 0; i < featureValues.length; i++) {
			builder.append(featureValues[i]);
			if (i < featureValues.length - 1) {
				builder.append(X);
			}
		}
		return builder.toString();
	}

	public String getName() {
		if (name == null) {
			StringBuilder builder = new StringBuilder(featureContext.name);
			builder.append(X);
			for (int i = 0; i < featureSpecs.length; i++) {
				builder.append(featureSpecs[i].name);
				if (i < featureSpecs.length - 1) {
					builder.append(X);
				}
			}
			name = builder.toString();
		}
		return name;
	}
}
