package edu.cmu.cs.lti.avenue.navigation.featuredetection.inductive;

import java.util.ArrayList;

import edu.cmu.cs.lti.avenue.navigation.featuredetection.inductive.evidence.ObservedMorpheme;
import edu.cmu.cs.lti.avenue.navigation.featuredetection.inductive.evidence.NodeEvidence;

/**
 * A pattern of words (and possibly morphemes) being associated with a given
 * FeatureValueCluster (as shown by the NodeEvidence contained in each
 * ExpressedTheme instance). The ExpressedThemeManager can be used to get an
 * ExpressedTheme from a FeatureValueCluster. This class can be used with and
 * without stemming (e.g. via ParaMor). If no stemming has been performed, the
 * Paradigm array will have length zero and the word will be the same as the
 * morpheme.
 * 
 * @author jon
 */
public class ExpressedTheme {

	private ObservedMorpheme morpheme;
	private double weightedFrequency;
	private double probability;
	private ArrayList<NodeEvidence> evidence = new ArrayList<NodeEvidence>();

	public ExpressedTheme(ObservedMorpheme morpheme) {
		this.morpheme = morpheme;
	}

	public void setEvidence(ArrayList<NodeEvidence> evidence) {
		this.evidence = evidence;
	}

	public ArrayList<NodeEvidence> getEvidence() {
		return evidence;
	}

	public void setWeightedFrequency(double weightedFrequency) {
		this.weightedFrequency = weightedFrequency;
	}

	public double getWeightedFrequency() {
		return weightedFrequency;
	}

	public void setProbability(double probability) {
		this.probability = probability;
	}

	public double getProbability() {
		return probability;
	}

	public ObservedMorpheme getMorpheme() {
		return morpheme;
	}
}
