package edu.cmu.cs.lti.avenue.navigation.featuredetection.inductive;

import java.util.ArrayList;
import java.util.HashMap;

import edu.cmu.cs.lti.avenue.corpus.SentencePair;
import edu.cmu.cs.lti.avenue.trees.smart.SmartTree;

/**
 * Represents our current evidence we have collected plus the
 * knowledge/inferences about the language based on that evidence.
 * 
 * @author jon
 */
public class CurrentState {
	private ArrayList<SentencePair> elicitedSentences = new ArrayList<SentencePair>();
	private HashMap<SmartTree, ArrayList<SentencePair>> elicitedRealizations = new HashMap<SmartTree, ArrayList<SentencePair>>();
	private HashMap<SmartTree, ArrayList<SentencePair>> unelicitedRealizations = new HashMap<SmartTree, ArrayList<SentencePair>>();
	
	public void addElicitedSentence(SentencePair sentencePair) {
		elicitedSentences.add(sentencePair);
		
		SmartTree featureStructure = sentencePair.getFeatureStructure();
		ArrayList<SentencePair> realizations = elicitedRealizations.get(featureStructure);
		if(realizations == null) {
			realizations = new ArrayList<SentencePair>(1);
			elicitedRealizations.put(featureStructure, realizations);
		}
		realizations.add(sentencePair);
	}
	
	public ArrayList<SentencePair> getElicitedSentences() {
		return elicitedSentences;
	}
	
	public ArrayList<SentencePair> getElicitedRealizations(SmartTree featureStructure) {
		ArrayList<SentencePair> list = elicitedRealizations.get(featureStructure);
		if(list == null)
			list = new ArrayList<SentencePair>(0);
		return list;
	}
	
	public ArrayList<SentencePair> getUnelicitedRealizations(SmartTree featureStructure) {
		ArrayList<SentencePair> list = unelicitedRealizations.get(featureStructure);
		if(list == null)
			list = new ArrayList<SentencePair>(0);
		return list;
	}
}
