/**
 * The AVENUE Project
 * Language Technologies Institute
 * School of Computer Science
 * (c) 2007 Carnegie Mellon University
 * 
 * Corpus Navigator
 * Written by Jonathan Clark
 */
package edu.cmu.cs.lti.avenue.navigation.featuredetection.deductive;

import edu.cmu.cs.lti.avenue.corpus.SentencePair;
import edu.cmu.cs.lti.avenue.trees.smart.TreeNode;
import edu.cmu.cs.lti.avenue.trees.smart.Variable;
import edu.cmu.cs.lti.avenue.trees.smart.SmartTree.LabelDisplay;

/**
 * A matching sentence pair that matches the left-hand-side of a Rule. TODO:
 * Implement caching of fnode lookups
 */
public class SentencePatternMatch {
	private final SentencePair match;
	private final String sentenceVariable;
	private final Variable[] variableValues;
	private final Rule rule;

	// private final KeyCache<String, TreeNode> fnodeCache;

	// private static final Logger log = LogUtils.getLogger();

	public SentencePatternMatch(String sentenceVariable, final Rule rule,
			final int nSentencePattern, SentencePair match, Variable[] variableValues) {

		this.sentenceVariable = sentenceVariable;
		this.match = match;
		this.variableValues = variableValues;
		this.rule = rule;

		// CacheGenerator<String, TreeNode> generator = new
		// CacheGenerator<String, TreeNode>() {
		// @Override
		// public TreeNode getUncachedValue(String key) throws Exception {
		// // example input: A (X)
		// // meaning for sentence A, match
		//				
		// Integer n = rule.getSentencePatternVariables().get(var);
		// if(n == null)
		// throw new RuntimeException("Unrecognized variable: " + var);
		// rule.getSentencePatterns()[nSentencePattern];
		//				
		// return null;
		// }
		// };
		//		
		// this.fnodeCache = new KeyCache<String, TreeNode>(generator, log);
	}

	public SentencePair getSentencePair() {
		return match;
	}

	public Variable[] getVariableValues() {
		return variableValues;
	}

	public String getVariableValuesAsString() {

		String[] variableNames = rule.getVariableData().variableNames;
		StringBuilder builder = new StringBuilder();

		for (int i = 0; i < variableValues.length; i++) {

			String variableName = variableNames[i];
			Variable valueList = variableValues[i];

			builder.append(variableName + " = { ");
			for (TreeNode value : valueList.getValues()) {
				builder.append(value.toString(LabelDisplay.NONE) + ", ");
			}
			builder.append("}; ");
		}

		return builder.toString();
	}

	/**
	 * The variable name used to refer to this sentence (e.g. A)
	 * 
	 * @return
	 */
	public String getSentenceVariable() {
		return sentenceVariable;
	}

	public String toString() {
		return sentenceVariable + ": " + match;
	}

	// public KeyCache<String, TreeNode> getFnodeCache() {
	// return fnodeCache;
	// }
}
